<?php
namespace app\components;

use Yii;
use yii\filters\AccessControl;;
use app\models\LoginForm;
use yii\filters\VerbFilter;
use yii\helpers\Url;

use app\models\Contract;
use app\models\Company;
use app\models\User;

/**
 * Site controller
 */
class Controller extends \yii\web\Controller
{
    public $req;
    public function beforeAction($action) {
        $this->req = Yii::$app->request;
        $this->enableCsrfValidation = false;
        return parent::beforeAction($action);
    }
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        $isGuest = Yii::$app->user->isGuest;
        $role = !$isGuest?Yii::$app->user->identity->role:false;
        $rules = [
            // reglas para usuarios sin loguear
            [
                'controllers' => ['site'],
                'actions' => ['login','signup','test','verify','error'],
                'allow' => true,
                'roles' => ['?'],
            ],
            [
                'allow' => false,
                'roles' => ['?'],
                'denyCallback' => function($rule,$action){
                    $this->redirect(Url::toRoute('site/login'));
                },
            ],
            // reglas para usuarios logueados
            [
                'allow' => true,
                'controllers' => ['site','incidents'],
                // 'actions' => ['logout'],
                'roles' => ['@'],
            ],
            [
                'allow' => !$isGuest && $role!=User::ROLE_DEPARTMENTMANAGER,
                'controllers' => ['contracts','payroll-concepts'],
                'roles' => ['@'],
                'denyCallback' => function($rule,$action){
                    $this->redirect(Url::toRoute('site/'));
                }
            ],
            [
                'allow' => !$isGuest && Yii::$app->user->identity->isAdmin(),
                'controllers' => ['employees'],
                'roles' => ['@'],
                'denyCallback' => function($rule,$action){
                    $this->redirect(Url::toRoute('site/'));
                }
            ],
            [
                'allow' => !$isGuest && $role!=User::ROLE_DEPARTMENTMANAGER,
                'controllers' => ['reports','requests'],
                'roles' => ['@'],
                'denyCallback' => function($rule,$action){
                    $this->redirect(Url::toRoute('site/'));
                }
            ],
            [
                'allow' => !$isGuest && $role==User::ROLE_MANAGER,
                // 'controllers' => ['users','companies','settings'],
                'roles' => ['@'],
                'denyCallback' => function($rule,$action){
                    $this->redirect(Url::toRoute('site/'));
                }
            ],
        ];
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => $rules,
            ]
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }
    public function actionNew()
    {
        return $this->renderModal('new',$this->newTitle);
    }
    public function actionIndex()
    {
        return $this->render('index');
    }
    protected function defaultCreate(&$model=null)
    {
        $modelName = $this->primaryModel;
        $r = ['success'=>false];
        $model = new $modelName;
        $model->load(Yii::$app->request->post());
        if(Yii::$app->user->identity->hasCompany($model->idCompany)){
            if($model->save()){
                $r['success']=true;
            }else{
                $aux =$model->getErrors();
                $r['message']=reset($aux)[0];
            }            
        }
        return $r;
    }
    public function actionCreate()
    {
        $req = $this->defaultCreate();
        if($req['success']){
            $req['callbackScript']="closeCurrentModal();";
        }
        return json_encode($req);
    }
    protected function defaultUpdate($model)
    {
        $r = ['success'=>false];
        $model->load(Yii::$app->request->post());
        if($model->save()){
            $r['success']=true;
        }else{
            $aux =$model->getErrors();
            $r['message']=reset($aux)[0];
        }
        return $r;
    }
    public function actionUpdate($id)
    {
        $class = $this->primaryModel;
        $req = $this->defaultUpdate($class::findOneByCompany($id));
        if($req['success']){
            // $req['callbackScript']="();";
        }
        return json_encode($req);
    }
    public function actionEdit($id)
    {
        $class = $this->primaryModel;
        $model = $class::findOneByCompany($id);
        return $this->renderModal('edit',"Edición de registro",['model'=>$class::findOne($id)]);
    }
    public function actionView($id)
    {
        $class = $this->primaryModel;
        return $this->renderPartial('view',['model'=>$class::findOneByCompany($id)]);        
    }
    public function actionDelete($id)
    {
        $class = $this->primaryModel;
        $class::findOneByCompany($id)->delete();
        return json_encode(['success'=>true,'callbackScript'=>'reloadAjaxTables();']);
    }
    public function generateHtmlActions($model,$modalWidth=false)
    {
        $modalWidthAttr = $modalWidth?"data-modal-width='$modalWidth'":'';
        $controller = Yii::$app->controller->id;
        return [
            "<a href='".Url::to(["$controller/edit",'id'=>$model->id])."' class='btn btn-xs btn-primary'  data-toggle='modalDinamic' $modalWidthAttr ><i class='fa fa-eye'></i></a>",
            "<a href='".Url::to(["$controller/delete",'id'=>$model->id])."' class='btn btn-xs btn-danger show-warning ajaxLink'><i class='fa fa-trash'></i></a>",
        ];
    }
    public function renderModal($view,$title='',$vars=[])
    {
        $controller = Yii::$app->controller->id;
        $view = '//'.$controller.'/'.$view;
        return $this->renderPartial('//layouts/modal',['vars'=>$vars,'title'=>$title,'view'=>$view]);
    }
    public function validDate($dateTimeObj)
    {
        $day = intval($dateTimeObj->format('d'));
        $month = intval($dateTimeObj->format('m'));
        $year = intval($dateTimeObj->format('Y'));
        return checkdate($month, $day, $year);
    }
    public function fixFormatDate($date)
    {
        // formato dd/mm/yyyy
        $aux = explode('/', $date);
        if(count($aux)==3) return implode('-', [$aux[2],$aux[1],$aux[0]]);
        return "";
    }
}