<?php 
namespace app\components;
use yii\base\Component;
use app\models\Employee;
use app\components\EmployeesComponent;

class PeriodsComponent extends Component{
	public static function getActiveEmployees($period,$idDepartments)
	{
		return self::getActiveEmployeesQuery($period,$idDepartments)->all();
	}
	public static function getActiveEmployeesQuery($period,$idDepartments)
	{
		$activeStatus = Employee::STATUS_ACTIVE;
		$inactiveStatus = Employee::STATUS_INACTIVE;
		$readmissionStatus = Employee::STATUS_READMISSION;
		return Employee::find()
		->joinWith('employeeChanges')
		->where([
			'Employees.idCompany'=>$period->idCompany,
			'Employees.idDepartment'=>$idDepartments
		])
		// ->andWhere("(
		// 	(Employees.creationDate <= '{$period->endDate}')
		// 	AND
		// 	(
		// 		(Employees.status = $activeStatus)
		// 		OR
		// 		(changeType = $readmissionStatus AND applyDate <= '{$period->endDate}')
		// 		OR
		// 		(changeType = $inactiveStatus AND applyDate >= '{$period->startDate}')
		// 	)
		// )")
		->andWhere("(
			(Employees.status = $activeStatus AND changeType = $activeStatus AND applyDate <= '{$period->endDate}')
			OR
			(changeType = $readmissionStatus AND applyDate <= '{$period->endDate}')
			OR
			(changeType = $inactiveStatus AND applyDate >= '{$period->startDate}')
		)")
		->orderBy(EmployeesComponent::$orderQuery);
	}
}