<?php 
namespace app\components\reports;
use app\components\reports\MainReportComponent;
use app\models\Employee;
use app\models\Incident;
use app\models\Company;
use app\models\Contract;
class Concepts extends MainReportComponent{
	public static function get($idCompany,$idDepartments,$idJobs,$status)
	{
        $r = new \PHPExcel;
        $r->getProperties()->setTitle("Empleados");
        $r->setActiveSheetIndex(0)->setTitle("Empleados");
        $s = $r->getActiveSheet();
        // estilo
        $s->getDefaultStyle()->getAlignment()->setHorizontal(\PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
        $s->getDefaultStyle()->getAlignment()->setVertical(\PHPExcel_Style_Alignment::VERTICAL_CENTER);
        $s->getDefaultStyle()->getFont()->setSize(8);
        $s->getDefaultStyle()->getFont()->setName("Century Gothic");

        $s->getDefaultRowDimension()->setRowHeight(18);
        $s->getDefaultColumnDimension()->setWidth(15);
        // Header
        $cols = self::getCols();
        $col = 0;
        $header1 = [
            "ID Empleado",
            "Nombre Empleado",
            "Horas extra",
            "Comisiones",
            "Anticipos",
            "Bonos",
            "Compensaciones",
            "Otras percepciones",
            "Prestamos",
            "Anticipos",
            "CXC",
            "Otras deducciones",
        ];
        foreach ($header1 as $h) {
            $cell = $cols[$col].'2';
            $s->setCellValue($cell,$h);
            $col++;
        }
        $s->getStyle("A2:{$cols[$col-1]}2")->getAlignment()->setWrapText(true);
        $s->getStyle("A2:{$cols[$col-1]}2")->applyFromArray(self::getStyle());
        $s->getRowDimension(2)->setRowHeight(30);
        $s->getColumnDimension('B')->setWidth(35);
        $row = 2;
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Empleados.xls"');
        header('Cache-Control: max-age=0');
        $objWriter = \PHPExcel_IOFactory::createWriter($r,'Excel5');
        $objWriter->setPreCalculateFormulas(false);
        $objWriter->save('php://output');
    }
    public function getDepartments($idCompany,$idDepartments)
    {
        $departments = Department::find()
        ->joinWith('employees')
        ->where(['Departments.id'=>$idDepartments,'idCompany'=>$idCompany])
        ->all();
        
    }
	public static function getEmployees($companies,$departments,$jobs,$status)
	{
		return Employee::find()
		->joinWith(['department','job','company'])
		->where(['idCompany'=>$companies,'idDepartment'=>$departments,'idJob'=>$jobs,'status'=>$status])
		->orderBy("Companies.name ASC, refId ASC")
		->all();
	}
}