<?php 
namespace app\components\reports;
use app\components\reports\MainReportComponent;
use app\components\PeriodsComponent;
use app\models\Employee;
use app\models\Incident;
use app\models\Period;
class ImpReportComponent extends MainReportComponent{
	public static function get($period)
    {
        $r = new \PHPExcel;
        $r->getProperties()->setTitle("Reporte IMP");
        $r->setActiveSheetIndex(0)->setTitle("IMP");
        $s = $r->getActiveSheet();
        // estilo
        $s->getDefaultStyle()->getAlignment()->setHorizontal(\PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
        $s->getDefaultStyle()->getAlignment()->setVertical(\PHPExcel_Style_Alignment::VERTICAL_CENTER);
        $s->getDefaultStyle()->getFont()->setSize(8);
        $s->getDefaultStyle()->getFont()->setName("Century Gothic");

        $s->getDefaultRowDimension()->setRowHeight(18);
        $s->getDefaultColumnDimension()->setWidth(15);
        // Titulos
        list($startDate,$endDate) = self::getRealDates($period);

        $s->setCellValue('A2','Empresa:');
        $s->setCellValue('B2',"SAAV CANCUN S.A de C.V");
        $s->setCellValue('A3','Cliente:');
        $s->setCellValue('B3',$period->company->name);
        $s->setCellValue('A4','Periodo:');
        $s->setCellValue('B4','Del: '.$period->getDateField('startDate','d/m/Y').' al '.$period->getDateField('endDate','d/m/Y'));
        $s->setCellValue('A5','Incidencias y conceptos:');
        $s->setCellValue('B5','Del: '.date('d/m/Y',strtotime($startDate)).' al '.date('d/m/Y',strtotime($endDate)));
        $s->freezePane('C8');
        $s->getColumnDimension('B')->setWidth(45);
        $s->getColumnDimension('C')->setWidth(35);
        $s->getColumnDimension('D')->setWidth(30);
        // Header
        $cols = self::getCols();
        $col = 0;
        $header1 = [
            "ID Empleado",
            "Nombre Empleado",
            "Puesto",
            "Departamento",
        ];
        foreach ($header1 as $h) {
            $s->mergeCells($cols[$col].'6:'.$cols[$col].'7')->setCellValue($cols[$col++].'6',$h);
        }
        $header2 = [
            "Faltas",
            "Incapacidad",
            "Retardos",
            "Permiso C/goce",
            "Permiso S/goce",
            "Suspensión de labores S/goce",
            "Hora extraordinaria",
            "Domingo laborado",
            "Descanso laborado",
            "Turno doble",
            "Día festivo",
        ];
        $s->mergeCells("{$cols[$col]}6:{$cols[$col+count($header2)-1]}6")->setCellValue("{$cols[$col]}6","Por eventos");
        foreach ($header2 as $h) {
            $s->setCellValue($cols[$col++].'7',$h);
        }
        $header3 = [
            "Retroactivo",
            "Comisiones",
            "Bono",
            "Compensaciones",
            "Anticipos",
            "Otras percepciones",
            "CxC",
            "Prestamos",
            "Vacaciones",
            "Anticipos",
            "Otros Descuentos",
            "Observaciones",
        ];
        $s->mergeCells("{$cols[$col]}6:{$cols[$col+count($header3)-1]}6")->setCellValue("{$cols[$col]}6","Por importe");
        foreach ($header3 as $h) {
            $s->setCellValue($cols[$col++].'7',$h);
        }
        $s->getStyle("A6:{$cols[$col-1]}7")->getAlignment()->setWrapText(true);
        $s->getStyle("A6:{$cols[$col-1]}7")->applyFromArray(self::getStyle());
        $s->getRowDimension(6)->setRowHeight(30);
        $s->getRowDimension(7)->setRowHeight(30);
        self::setEmployees($s,$period,$startDate,$endDate);

        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Incidencias.xls"');
        header('Cache-Control: max-age=0');
        $objWriter = \PHPExcel_IOFactory::createWriter($r,'Excel5');
        $objWriter->setPreCalculateFormulas(false);
        $objWriter->save('php://output');
    }
    private static function setEmployees($s,$period,$startDate,$endDate)
    {
        $row = 8;
        $cols = self::getCols();
        $employees = self::getActiveEmployees($period);
        foreach ($employees as $emp) {
            $values = [
                $emp->refId,
                $emp->fullNameInverse,
                $emp->job->name,
                $emp->department->name,
                // eventos
                self::getCountIncidentCategory($emp,$startDate,$endDate,'F'),
                self::getCountIncidentCategory($emp,$startDate,$endDate,'INC'),
                self::getCountIncidentCategory($emp,$startDate,$endDate,'R'),
                self::getCountIncidentCategory($emp,$startDate,$endDate,'PCG'),
                self::getCountIncidentCategory($emp,$startDate,$endDate,'PSG'),
                0,
                self::getPayrollConcept($emp,$period,'horasExtraP'),
                self::getCountIncidentCategory($emp,$startDate,$endDate,'DL'),
                self::getCountIncidentCategory($emp,$startDate,$endDate,'DT'),
                self::getCountIncidentCategory($emp,$startDate,$endDate,'TD'),
                self::getCountIncidentCategory($emp,$startDate,$endDate,'FL'),

                0,
                self::getPayrollConcept($emp,$period,'comisionesP'),
                self::getPayrollConcept($emp,$period,'bonosP'),
                self::getPayrollConcept($emp,$period,'compensacionesP'),
                self::getPayrollConcept($emp,$period,'anticiposP'),
                self::getPayrollConcept($emp,$period,'otrosP'),
                
                self::getPayrollConcept($emp,$period,'cxcD'),
                self::getPayrollConcept($emp,$period,'prestamosD'),
                self::getCountIncidentCategory($emp,$startDate,$endDate,'V'),
                self::getPayrollConcept($emp,$period,'anticiposD'),
                self::getPayrollConcept($emp,$period,'otrosD'),
            ];
            $col = 0;
            foreach ($values as $v) $s->setCellValue($cols[$col++].$row,$v);
            $row++;
        }
    }
    private static function getRealDates($period)
    {
        //este reporte debe entregar las incidencias de los días que se toman en cuenta en el cierre de periodo
        // toma en cuenta los días sin cerrar del periodo anterior hasta el ultimo día que se cerro incidencias.
        $startDate = $period->startDate;
        $endDate = $period->endDate;
        $prevPeriod = Period::find()
        ->where(['idCompany'=>$period->idCompany])
        ->andWhere("endDate < '{$period->startDate}'")
        ->orderBy('startDate DESC')
        ->one();
        if($prevPeriod && $prevPeriod->status!=Period::STATUS_OPEN) $startDate = date('Y-m-d',strtotime($prevPeriod->incidentsLastDate.' +1 day'));
        if($period->status!=Period::STATUS_OPEN) $endDate = $period->incidentsLastDate;
        return [$startDate,$endDate];
    }
    public static function getCountIncidentCategory($emp,$startDate,$endDate,$tag)
    {
        return $emp->getIncidents()
        ->where("date >= '{$startDate}' AND date <= '{$endDate}'")
        ->joinWith('incidentCategory')
        ->andWhere(['IncidentCategories.tag'=>$tag])
        ->count();
    }
    public static function getPayrollConcept($emp,$period,$tag)
    {
        $p = $emp->getPayrollConcepts()
        ->where(['idPeriod'=>$period->id])
        ->one();
        if($p){
            return $p->$tag;
        }
        return 0;
    }
    public static function getActiveEmployees($period)
    {
        $activeStatus = Employee::STATUS_ACTIVE;
        $inactiveStatus = Employee::STATUS_INACTIVE;
        $readmissionStatus = Employee::STATUS_READMISSION;

        return Employee::find()
        ->joinWith('employeeChanges')
        ->where([
            'Employees.idCompany'=>$period->idCompany,
        ])
        ->andWhere("(
            (Employees.status = $activeStatus AND changeType = $activeStatus AND applyDate <= '{$period->endDate}')
            OR
            (changeType = $readmissionStatus AND applyDate <= '{$period->endDate}')
            OR
            (changeType = $inactiveStatus AND applyDate >= '{$period->startDate}')
        )")
        ->orderBy('(refId * 1) ASC')
        ->all();
    }
}