<?php 
namespace app\components\reports;
use yii\base\Component;
use app\models\Employee;
use app\models\Contract;
class MainReportComponent extends Component{
	public static function getStyle($style='header')
	{
		$styles['header']=[
			'font' => [
					'bold' => true,
					'color' => ['rgb' => 'FFFFFF']
				],
			'fill' => [
				'type' => \PHPExcel_Style_Fill::FILL_SOLID,
				'color' => ['rgb' => '09395B'],
				'size'=>12,
				],
			'alignment' => [
				'horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER
				],
			'borders'=> [
						'allborders' => [
							'style' => \PHPExcel_Style_Border::BORDER_THIN,
							'color' => ['argb' => '#000000']
						]
					]
			];
		$styles['background'] = [
			'fill' => [
				'type' => \PHPExcel_Style_Fill::FILL_SOLID,
				'color' => ['rgb' => 'E0E0E0']
				]
			];

		$styles['background2'] = [
			'fill' => [
				'type' => \PHPExcel_Style_Fill::FILL_SOLID,
				'color' => ['rgb' => '858585']
				]
			];

		$styles['allborders'] = [
			'borders'=> [
						'allborders' => [
							'style' => \PHPExcel_Style_Border::BORDER_THIN,
							'color' => ['argb' => '#000000']
						]
					]
			];
		return $styles[$style];
	}
	public static function getCols()
	{
		$cols = [];
		foreach (['','A','B','C'] as $i) for($j='A'; $j<= 'Z';$j++) $cols[]=$i.$j;
		return $cols;
	}
	public static function validDate($dateTimeObj)
    {
        $day = intval($dateTimeObj->format('d'));
        $month = intval($dateTimeObj->format('m'));
        $year = intval($dateTimeObj->format('Y'));
        return checkdate($month, $day, $year);
    }
}