<?php
namespace app\controllers;

use \Yii;
use app\components\Controller;
use app\components\SettingsComponent;
use app\components\EmployeesComponent;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use app\models\Employee;
use app\models\EmployeeChange;
use app\models\Contract;
use app\models\Period;
use app\models\ContractType;
use app\models\Company;
use app\models\Department;
use app\models\Job;
use yii\web\UploadedFile;

class EmployeesController extends Controller
{
    public $primaryModel = "\app\models\Employee";
    public $newTitle = "Registro de Empleado";
    public function actionSearch()
    {
        return $this->renderModal('search','Buscar');
    }
    public function actionNew()
    {
        $model = new Employee;
        return $this->renderPartial('info',['model'=>$model]);
    }
    public function actionIndex()
    {
        $employees = Employee::findByCompany()->all();
        return $this->render('index2',['employees'=>$employees]);
    }
    public function actionSave($id=-1)
    {
        $isNew = false;
        $r = ['success'=>false];
        if($id==-1){
            $model = new Employee;
            $isNew;
        }else{
            $model = Employee::findOneByCompany($id);
        }
        $model->load($this->req->post());
        $model->breakDays = implode('',$this->req->post('breakDays',[]));
        $model->jsonChildrens = $this->getChildrens();
        if($model->save()){
            if($isNew) EmployeesComponent::saveChangeStatus($model,$model->entryDateSaav);
            $r['success']=true;
        }else{
            $aux = $model->getErrors();
            $r['message']=reset($aux)[0];
        }
        return json_encode($r);
    }
    public function actionCreate()
    {
        $model = new Employee;
        $r = ['success'=>false];
        $model->load(Yii::$app->request->post());
        $model->jsonChildrens = $this->getChildrens();
        if($model->save()){
            $this->updateDocs($model);
            EmployeesComponent::saveChangeStatus($model,$model->entryDateSaav);
            $r['success']=true;
            $editLink = Url::to(['employees/edit','id'=>$model->id]);
            $req['callbackScript']="
                closeCurrentModal(function(){
                    generateModal(null,'$editLink',1000);
                });
            ";
        }else{
            $aux = $model->getErrors();
            $r['message']=reset($aux)[0];
        }
        return json_encode($r);
    }
    public function getChildrens()
    {
        $names = $this->req->post('childrenNames',[]);
        $ages = $this->req->post('childrenAges',[]);
        $childrens = [];
        foreach ($names as $i=>$name) {
            if($name!=""){
                $child = new \StdClass;
                $child->name = $name;
                $child->age = $ages[$i];
                $childrens[]=$child;                
            }
        }
        return json_encode($childrens);
    }
    public function actionEdit($id)
    {
        $model = Employee::findOneByCompany($id);
        // list($prev,$next) = $this->getPrevNextEmployee($model->id,$model->idCompany);
        return $this->renderPartial('info',['model'=>$model]);
    }
    public function getPrevNextEmployee($idEmployee,$idCompany)
    {
        $prev = 0;
        $next = 0;
        $employees = Employee::find()
        ->select(['id'])
        ->where(['idCompany'=>$idCompany,'status'=>Employee::STATUS_ACTIVE])
        ->orderBy(EmployeesComponent::$orderQuery)
        ->all();
        $break=false;
        foreach ($employees as $emp) {
            if($break){
                $next = $emp->id;
                break;
            }
            if($emp->id==$idEmployee) $break = true;
            else $prev = $emp->id;
        }
        return [$prev,$next];
    }
    public function actionUpdate($id)
    {
        $r = ['success'=>false];
        $model = Employee::findOneByCompany($id);
        $model->load($this->req->post());
        $model->breakDays = implode('',$this->req->post('breakDays',[]));
        $model->jsonChildrens = $this->getChildrens();
        if($model->save()){
            $this->updateDocs($model);
            $r['success']=true;
            $r['message']="Actualización exitosa";
        }else{
            $aux = $model->getErrors();
            $r['message']=reset($aux)[0];
        }
        return json_encode($r);
    }
    public function actionEditStatus($id)
    {
        $model = Employee::findOneByCompany($id);
        if($model->status==Employee::STATUS_INACTIVE) $title = "Reingreso de empleado";
        else $title = "Baja de empleado";
        return $this->renderModal('editStatus',$title,['model'=>$model]);
    }
    public function actionEditSalary($id,$updatems=0)
    {
        $model = Employee::findOneByCompany($id);
        if($updatems) $model->minimumSalary = SettingsComponent::getMinimumSalary();
        return $this->renderModal('editSalary','Edición de salario',['model'=>$model,'updatems'=>$updatems]);   
    }
    public function actionDeleteChange($id)
    {
        $change = EmployeeChange::findOne($id);
        $employee = $change->employee;
        $lastChange = $employee->lastChange;
        $changeType = $change->changeType;
        if(Yii::$app->user->identity->hasCompany($change->employee->idCompany) && $lastChange->id==$id && $lastChange->changeType!=EmployeeChange::CHANGE_TYPE_STATUS_ACTIVE){
            $change->delete();
            $lastChange = $employee->lastChange;
            if($changeType == EmployeeChange::CHANGE_TYPE_SALARY){
                $employee->updateAttributes(['salaries'=>$lastChange->salaries]);
            }else if($changeType == EmployeeChange::CHANGE_TYPE_STATUS_READMISSION){
                $employee->updateAttributes(['status'=>$lastChange->status,'entryDateSaav'=>$lastChange->entryDateSaav,'entryDateCompany'=>$lastChange->entryDateCompany]);
            }else{
                $employee->updateAttributes(['status'=>$lastChange->status]);
            }
        }
        return json_encode(['success'=>'true','callbackScript'=>'reloadAjaxTables();']);
    }
    public function actionUpdateStatus($id)
    {
        $req = Yii::$app->request;
        $r = ['success'=>false];
        $model = Employee::findOne($id);
        $status = $model->statusToUp?Employee::STATUS_READMISSION:Employee::STATUS_INACTIVE;
        $applyDate = $req->post('applyDate',false);
        $salaries = $req->post('salaries',$model->salaries);
        if($status){
            $lastPeriodDate = $this->getIncidentLastDate($model->idCompany);
            if($lastPeriodDate===false || $applyDate > $lastPeriodDate){
                if($status!=$model->status){
                    $attrs = ['status'=>$status];
                    if($status==Employee::STATUS_READMISSION){
                        $attrs['entryDateCompany'] = $applyDate;
                        $attrs['entryDateSaav'] = $applyDate;
                        $attrs['salaries'] = $salaries;
                    }
                    if($model->updateAttributes($attrs)){
                        EmployeesComponent::saveChangeStatus($model,$applyDate);
                        $r['success']=true;
                    }
                }else{
                    $r['message']="No se ha modificado el estatus";
                }
            }else{
                $r['message'] = "La fecha de aplicación debe ser mayor al ultima cierre de incidencias.";
            }
        }
        return json_encode($r);
    }
    public function getIncidentLastDate($idCompany)
    {
        $lastP = Period::findByCompany($idCompany)
        ->andWhere(['status'=>Period::STATUS_CLOSE])
        ->orderBy('startDate DESC')->one();
        if($lastP) return $lastP->incidentsLastDate;
        return false;
    }   
    public function actionBankAccount($id)
    {
        $model = Employee::findOne($id);
        return $this->renderModal('editBankAccount','Datos Bancarios',['model'=>$model]);
    }
    public function actionUpdateSalary($id)
    {
        $req = Yii::$app->request;
        $r=['success'=>false];
        $emp = Employee::findOneByCompany($id);
        $applyDate = $req->post('applyDate',false);
        $salaries = $req->post('salaries');
        if ($emp->status!=Employee::STATUS_INACTIVE) {
            if($salaries!=$emp->salaries){
                // if($applyDate >= date('Y-m-d')){
                    if($emp->updateAttributes(['salaries'=>$salaries])){
                        EmployeesComponent::saveChangeSalary($emp,$applyDate);
                        $r['success']=true;
                        $r['message']="Salario actualizado";
                        $r['callbackScript']="reloadCurrentModal();";
                    }else{
                        $aux = $emp->getErrors();
                        $r['message']=reset($aux)[0];
                    }
                // }else{
                    // $r['message'] = "La fecha de aplicación debe ser mayor o igual al día de hoy.";
                // }            
            }else{
                $r['message'] = "El salario no se ha modificado";
            }
        }else{
            $r['message'] = "No se permite modificaciones de salario para empleados con estatus BAJA";
        }
        return json_encode($r);
    }
    public function updateDocs($model)
    {
        $model->interviewNotes = $_POST['Employee']['interviewNotes'];
        $model->jsonDocs = json_encode(isset($_POST['docs'])?$_POST['docs']:[]);
        $model->save();
    }
    public function actionListing()
    {
        $models = Employee::findByCompany()->joinWith(['department','job','company']);
        $colsQuery = ['refId','CONCAT(Employees.lastName1," ",Employees.lastName2,"",Employees.firstName)','idDepartment','idJob','status','idCompany','Employees.id'];
        $colsOrder = ['(CASE WHEN (refId*1)=0 THEN 99999 ELSE (refId*1) END)','lastName1','Departments.name','Jobs.name','status','Companies.name','id'];
        $totalAll = $models->count();
        // criteria
        foreach ($colsQuery as $index => $c) {
            $aux = $_GET['columns'][$index]['search']['value'];
            if($aux!=""){
                if($c=='status' && $aux==1) $aux = [1,3];
                $models->andWhere(['LIKE',$c,$_GET['columns'][$index]['search']['value']]);
            }
        }
        // var_dump($models->createCommand()->sql);
        $totalFiltered = $models->count();
        $models->orderBy($colsOrder[$_GET['order'][0]['column']].' '.$_GET['order'][0]['dir']);
        $models->limit($_GET['length'])->offset($_GET['start']);
        $r=[];
        $r['draw'] = $_GET['draw'];
        $r['recordsTotal']=$totalAll;
        $r['recordsFiltered']=$totalFiltered;
        $r['data']=[];
        foreach($models->all() as $m) {
            $actions=[];
            $actions[]="<a data-modal-width='90%' href='".Url::to(['employees/edit','id'=>$m->id])."' class='btn btn-xs btn-primary'  data-toggle='modalDinamic' data-modal-width='800'><i class='fa fa-eye'></i></a>";
            $actions[]="<a href='".Url::to(['employees/delete','id'=>$m->id])."' class='btn btn-xs btn-danger show-warning ajaxLink'><i class='fa fa-trash'></i></a>";
            $r['data'][]=[
                $m->refId,
                implode(' ', [$m->lastName1,$m->lastName2,$m->firstName]),
                $m->department->name,
                $m->job->name,
                Employee::getStatusOptions()[$m->status],
                $m->company->name,
                "<div class='text-center'>".implode('',$actions)."</div>",
            ];
        }
        $r['error']='';
        return json_encode($r);
    }
    public function actionListing2()
    {
        $models = Employee::findByCompany();
        $cols = ['refId','CONCAT(Employees.lastName1," ",Employees.lastName2,"",Employees.firstName)'];
        $totalAll = $models->count();
        // criteria
        $query = $_GET['columns'][0]['search']['value'];
        if ($query!="") $models->andWhere("(CONCAT(Employees.lastName1,' ',Employees.lastName2,' ',Employees.firstName) LIKE :q OR refId LIKE :q)",[':q'=>'%'.$query.'%']);

        // var_dump($models->createCommand()->sql);
        $totalFiltered = $models->count();
        $models->orderBy($cols[$_GET['order'][0]['column']].' '.$_GET['order'][0]['dir']);
        $models->limit($_GET['length'])->offset($_GET['start']);
        $r=[];
        $r['draw'] = $_GET['draw'];
        $r['recordsTotal']=$totalAll;
        $r['recordsFiltered']=$totalFiltered;
        $r['data']=[];
        $actionButtonClass=$_GET['columns'][1]['search']['value'];
        foreach($models->all() as $m) {
            $actions=[];
            $actions[]="<a href='{$m->id}' class='$actionButtonClass btn btn-xs btn-primary' ><i class='fa fa-eye'></i></a>";
            $r['data'][]=[
                $m->refId,
                implode(' ', [$m->lastName1,$m->lastName2,$m->firstName]),
                "<div class='text-center'>".implode('',$actions)."</div>",
            ];
        }
        $r['error']='';
        return json_encode($r);
    }
    public function actionListingChanges($id)
    {
        $models = EmployeeChange::find()->where(['idEmployee'=>$id]);
        $cols = ['creationDate','changeType','applyDate','idCreationUser','id'];
        $totalAll = $models->count();
        $totalFiltered = $models->count();
        $models->orderBy($cols[$_GET['order'][0]['column']].' '.$_GET['order'][0]['dir']);
        $models->limit($_GET['length'])->offset($_GET['start']);
        $r=[];
        $r['draw'] = $_GET['draw'];
        $r['recordsTotal']=$totalAll;
        $r['recordsFiltered']=$totalFiltered;
        $r['data']=[];
        $emp = Employee::findOneByCompany($id);
        $lastChange = $emp->lastChange;
        foreach($models->all() as $m) {
            $actions=[];
            $actions[]="<a href='".Url::to(['employees/print-change','id'=>$m->id])."' class='btn btn-xs btn-info' target='_blank'><i class='fa fa-print'></i></a>";
            if($lastChange->id==$m->id) $actions[]="<a href='".Url::to(['employees/delete-change','id'=>$m->id])."' class='btn btn-xs btn-danger show-warning ajaxLink'><i class='fa fa-trash'></i></a>";
            $r['data'][]=[
                $m->getDateField('creationDate','d/m/Y H:i:s'),
                EmployeeChange::$changeTypeOptions[$m->changeType],
                $m->getDateField('applyDate','d/m/Y'),
                $m->creationUser->username,
                "<div class='text-center'>".implode('',$actions)."</div>",
            ];
        }
        $r['error']='';
        return json_encode($r);
            
    }
    public function actionImport()
    {
        return $this->renderModal('import','Importación de empleados');
    }
    public function actionDoImport()
    {
        $file = UploadedFile::getInstanceByName('employees');
        $excel = \PHPExcel_IOFactory::createReader('Excel2007');
        $excel = $excel->load($file->tempName);
        $excel->setActiveSheetIndex(0);
        $s = $excel->getActiveSheet();
        $lastRow = $s->getHighestRow();
        $errors = [];
        $employees = [];
        $contracts = [];
        for($row=2;$row<=$lastRow;$row++){
            list($rowData) = $s->rangeToArray("A$row:AI$row",true,true,true);
            if ($rowData[0]!==true) {
                $emp = new Employee;
                $this->setEmployeeData($emp,$rowData);              
                if($emp->validate()){
                    $employees[$row]=$emp;
                    if($rowData[29]=='SI'){
                        // crear primer contrato
                        $contract = new Contract;
                        $contract->idEmployee = 0;
                        $contract->idDepartment = 0;
                        $contract->idJob = 0;
                        $contract->minimumSalary = SettingsComponent::getSetting('minimumSalary');
                        $contract->salaries = $emp->salaries;
                        $this->setContractData($contract,$rowData);
                        if($contract->validate()){
                            $contracts[$row]=$contract;
                        }else{
                            $errors[$row]=['message'=>reset($contract->getErrors())[0],'form'=>'Contrato'];;
                        }
                    }
                }else{
                    $aux = $emp->getErrors();
                  $errors[$row]=['message'=>reset($aux)[0],'form'=>'Empleado'];
                }
            }
        }
        if(count($errors)==0){
            // todos los modelos pasaron validación
            foreach ($employees as $row => $emp) {
                $emp->save();
                if(isset($contracts[$row])){
                    $contracts[$row]->idEmployee = $emp->id;
                    $contracts[$row]->idDepartment = $emp->idDepartment;
                    $contracts[$row]->idJob = $emp->idJob;
                    $contracts[$row]->save();
                }
            }
        }
        return $this->renderPartial('import-result',['errors'=>$errors]);
    }
    public function setEmployeeData(&$model,$data)
    {
        $employeeAttrs = $this->getEmployeeAttrs();
        $contractAttrs = $this->getContractAttrs();

        $maritalStatusOptions = [
            'S'=>Employee::MARITALSTATUS_SINGLE,
            'C'=>Employee::MARITALSTATUS_MARRIED,
            'UL'=>Employee::MARITALSTATUS_COMMONLAWUNION,
        ];

        foreach ($employeeAttrs as $i=>$attr) {
            switch ($attr) {
                case 'localEmployee':
                    $model->localEmployee = $data[$i]=='SI';
                    break;
                case 'maritalStatus':
                    $model->maritalStatus = isset($maritalStatusOptions[$data[$i]])?$maritalStatusOptions[$data[$i]]:'.';
                    break;
                case 'birthDate':
                    $model->birthDate = $this->fixformatDate($data[$i]);
                    // var_dump($model->birthDate);
                    break;
                case 'idCompany':
                    $aux = Company::findOne(['name'=>$data[$i]]);
                    $model->idCompany = $aux?$aux->id:-1;
                    break;
                case 'idDepartment':
                    $aux = Department::findOne(['name'=>$data[$i]]);
                    $model->idDepartment = $aux?$aux->id:-1;
                    break;
                case 'idJob':
                    $aux = Job::findOne(['name'=>$data[$i]]);
                    $model->idJob = $aux?$aux->id:-1;
                    break;
                case 'entryDateCompany':
                    $model->entryDateCompany = $this->fixformatDate($data[$i]);
                    break;
                case 'entryDateSaav':
                    $model->entryDateSaav = $this->fixformatDate($data[$i]);
                    break;
                case 'nss':
                    $model->nss = strval($data[$i]);
                    break;
                default:
                    $model->$attr = $data[$i];
                    break;
            }
        }
        // var_dump($model->gender);
    }
    public function setContractData(&$model,$data)
    {
        $employeeAttrs = $this->getEmployeeAttrs();
        $contractAttrs = $this->getContractAttrs();

        $maritalStatusOptions = [
            'S'=>Employee::MARITALSTATUS_SINGLE,
            'C'=>Employee::MARITALSTATUS_MARRIED,
            'UL'=>Employee::MARITALSTATUS_COMMONLAWUNION,
        ];

        $i = count($employeeAttrs)+1;
        foreach ($contractAttrs as $attr) {
            switch ($attr) {
                case 'startDate':
                    $model->startDate = $this->fixformatDate($data[$i]);
                    break;
                case 'endDate':
                    $model->endDate = $this->fixformatDate($data[$i]);
                    break;
                case 'idContractType':
                    $aux = ContractType::findOne(['name'=>$data[$i]]);
                    $model->idContractType = $aux?$aux->id:-1;
                    break;
        //         case 'nss':
        //             var_dump($data[$i]);
                    // break;
                default:
                    if($data[$i]===true) $model->$attr = "";
                    else $model->$attr = $data[$i];
                    break;
            }
            $i++;
        }
    }
    public function actionFixIds()
    {
        # code...
    }
    public function getEmployeeAttrs()
    {
        return [
            'refId',
            'firstName',
            'lastName1',
            'lastName2',
            'gender',
            'maritalStatus',
            'email',
            'phone',
            'localEmployee',
            'mobilePhone',
            'birthDate',
            'addressOfBirth',
            'curp',
            'rfc',
            'nss',
            'city',
            'state',
            'address',
            'postalCode',
            'bankAccountBank',
            'bankAccountAccountNumber',
            'bankAccountClabe',
            'bankAccountCardNumber',
            'idCompany',
            'idDepartment',
            'idJob',
            'entryDateCompany',
            'entryDateSaav',
            'salaries',
        ];
    }
    public function getContractAttrs()
    {
        return [
            'idContractType',
            'startDate',
            'endDate',
            'freeTime',
            'testDays',
        ];
    }
    public function actionPrintChange($id)
    {
        $change = EmployeeChange::findOne($id);
        if($change && Yii::$app->user->identity->hasCompany($change->employee->idCompany)){
            $pdf = EmployeesComponent::getEmployeeChangePdf($change);
            $pdf->Output($change->fileName.".pdf",'I');
        }
    }
    public function actionMigrate()
    {
        $count = 0;
        foreach (Employee::find()->all() as $emp) {
            if(is_numeric($emp->refId)){
                $r = $emp->updateAttributes(['refId'=>intval($emp->refId)]);
                if($r) $count++;
            }
        }
        return $count;
    }
}