<?php 
namespace app\controllers;

use \Yii;
use app\components\Controller;
use app\models\Holiday;

class HolidaysController extends Controller{
	public $primaryModel = "\app\models\Holiday";
	public $newTitle = "Nuevo día festivo";

	public function actionCreate(){
		$r=['success'=>false];
		$hol = new Holiday();
		$hol->attributes = $this->req->post('Holiday');
		if($hol->save()) $r['success']=true;
		return json_encode($r);
	}
	public function actionUpdate($id=false)
	{
		$r=['success'=>false];
		$hol = Holiday::findOne($id);
		$hol->attributes = $this->req->post('Holiday');
		if($hol->save()) $r['success']=true;
		return json_encode($r);
	}
	public function actionListing()
    {
    	$models = Holiday::find();
		$cols = ['date','description','date'];
		$totalAll = $models->count();
		// criteria
		foreach ($cols as $index => $c) {
			$models->andWhere(['like',$c,$_GET['columns'][$index]['search']['value']]);
		}
		$totalFiltered = $models->count();
		$models->orderBy($cols[$_GET['order'][0]['column']].' '.$_GET['order'][0]['dir']);
		$models->limit($_GET['length'])->offset($_GET['start']);
		$r=[];
		$r['draw'] = $_GET['draw'];
		$r['recordsTotal']=$totalAll;
		$r['recordsFiltered']=$totalFiltered;
		$r['data']=[];
		foreach($models->all() as $m) {
			$actions=$this->generateHtmlActions($m);
			$r['data'][]=[
				$m->date,
				$m->description,
				"<div class='text-center'>".implode('',$actions)."</div>",
			];
		}
		$r['error']='';
		return json_encode($r);
    }
    public function actionDelete($id)
    {
        $hol = Holiday::findOne($id);
        if($hol){
        	$hol->delete();
        }
        return json_encode(['success'=>true,'callbackScript'=>'reloadAjaxTables();']);
    }
    public function actionEdit($id)
	{
		$d = Holiday::findOne($id);
		return $this->renderModal('edit','Editar registro',['model'=>$d]);
	}


}
 ?>
