<?php
namespace app\controllers;

use \Yii;
use app\components\Controller;
use yii\helpers\Url;
use app\models\Period;
use app\models\Company;
use app\models\Employee;
use app\models\IncidentCategory;
use app\models\WorkingPeriod;

class PeriodsController extends Controller
{
	public $primaryModel = "\app\models\Period";
	public function actionGenerate($id)
	{
		$r = ['success'=>false];
		if(isset($_POST['dates']) && $_POST['dates']){
			foreach ($_POST['dates'] as $i => $d) {
				$aux = new Period;
				$dAux = explode('/',$d[0]);
				$aux->startDate = "{$dAux[2]}-{$dAux[1]}-{$dAux[0]}";
				$dAux = explode('/',$d[1]);
				$aux->endDate = "{$dAux[2]}-{$dAux[1]}-{$dAux[0]}";
				$aux->idCompany = $id;
				$aux->status = Period::STATUS_OPEN;
				$aux->save();
			}	
			$r['success']=true;
			$r['callbackScript']="closeCurrentModal(reloadCurrentModal);";
		}else{
			$r['message']="Debe generar los periodos antes de guardar";
		}
		return json_encode($r);
	}
	public function actionGenerateFirst($id)
	{
		$company = Company::findOne($id);
		return $this->renderModal('generate','Creación de periodos',['model'=>$company]);
	}
	public function actionView($id)
	{
		$period = Period::findOne($id);
		return $this->renderModal('view','Detalles del periodo',['period'=>$period]);
	}
	public function actionCalcDates()
	{
		$workingPeriod = WorkingPeriod::findOne(Yii::$app->request->post('wp'));
		$startDate = Yii::$app->request->post('startDate');
		$endDate = Yii::$app->request->post('endDate');
		$dates = $this->calcDates($workingPeriod,$startDate,$endDate);
		return $this->renderPartial('dates',['dates'=>$dates]);
	}
	public function calcDates($workingPeriod,$startDate,$endDate)
	{
		$dates = [];
		$auxDate = new \DateTime($startDate);
		$endDate = new \DateTime($endDate);
		$days = intval($workingPeriod->days)-1;
		while ($auxDate <= $endDate) {
			$aux = [$auxDate->format('d/m/Y')];
			if($days==6){
				$auxDate->modify("+6 days");				
			}else if($days==14){
				if($auxDate->format('d')==16){
					$auxDate = new \DateTime($auxDate->format('Y-m-t'));
				}else{
					$auxDate->modify("+14 days");
				}
			}else{
				// mensual
				if($auxDate->format('d')==1){
					$auxDate = new \DateTime($auxDate->format('Y-m-t'));
				}else{
					$auxDate->modify("+1 month");
				}
			}
			$aux[]=$auxDate->format('d/m/Y');
			$auxDate->modify("+1 days");
			$dates[]=$aux;
		}
		return $dates;
	}
	public function actionNew()
	{
		// busca ultimo periodo
		$lastP = Period::findByCompany(Yii::$app->request->get('company'))->orderBy('id DESC')->one();
		$period = new Period;
		$period->idCompany=Yii::$app->request->get('company');
		if($lastP){
			// tomamos la fecha final para crear el próximo periodo
			$period->startDate = date('Y-m-d',strtotime($lastP->endDate.' +1 day'));
			$days = round($period->company->workingPeriod->days);
			$period->endDate = date('Y-m-d',strtotime($lastP->endDate.' +'.$days.' day'));
		}	
		return $this->renderModal('new','Confirma fechas de nuevo periodo',['model'=>$period]);
	}
	public function actionListing()
    {
    	$models = Period::findByCompany(Yii::$app->request->get('company'));
    	$cols = ['startDate','endDate','idUserClosure','closureDate','id'];
		$totalAll = $models->count();
		// criteria
		foreach ($cols as $index => $c) {
			if(!empty($_GET['columns'][$index]['search']['value'])) $models->andWhere(['like',$c,$_GET['columns'][$index]['search']['value']]);
		}
		$totalFiltered = $models->count();
		$models->orderBy($cols[$_GET['order'][0]['column']].' '.$_GET['order'][0]['dir']);
		$models->limit($_GET['length'])->offset($_GET['start']);
		$r=[];
		$r['draw'] = $_GET['draw'];
		$r['recordsTotal']=$totalAll;
		$r['recordsFiltered']=$totalFiltered;
		$r['data']=[];
		$statusClasses = [
			Period::STATUS_OPEN=>'success',
			Period::STATUS_CLOSE=>'danger',
			Period::STATUS_REVIEW=>'warning',
		];
		foreach($models->all() as $m) {
			$actions=[];
			$actions[]="<a href='".Url::to(['periods/view','id'=>$m->id])."' class='btn btn-xs btn-info' data-toggle='modalDinamic'><i class='fa fa-eye'></i></a>";
			$r['data'][]=[
				date('d/m/Y',strtotime($m->startDate)),
				date('d/m/Y',strtotime($m->endDate)),
				"<div class='text-center'><span class='label label-{$statusClasses[$m->status]}'>".Period::$statusOptions[$m->status]."</span></div>",
				"<div class='text-center'>".($m->status==Period::STATUS_OPEN?'--/--/---- --:--:--':$m->getDateField('closureDate')->format('d/m/Y H:i:s'))."</div>",
				"<div class='text-center'>".implode('',$actions)."</div>",
			];
		}
		$r['error']='';
		return json_encode($r);
    }
}