<?php
namespace app\controllers;

use \Yii;
use app\components\Controller;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use app\models\ContractType;
use app\models\Company;
use app\models\Period;
use app\components\reports\ImpReportComponent;
use app\components\reports\Employees;
use app\components\reports\Concepts;
use app\components\reports\ExpirationsContracts;

class ReportsController extends Controller
{
	public function actionExportimp($period)
	{
		if(Yii::$app->user->identity->isAdmin()){
			$period = Period::findOne($period);
			ImpReportComponent::get($period);
			Yii::$app->end();
		}
		return "No tienes permisos";
	}
	public function actionExpirationsContracts()
	{
		if(Yii::$app->user->identity->isAdmin()){
			$req = Yii::$app->request;
			$companies = $req->post('companies',[]);
			$validCompanies = array_values(ArrayHelper::map(Yii::$app->user->identity->companies,'id','id'));
			$validCompanies = array_intersect($validCompanies, $companies);
			ExpirationsContracts::get($validCompanies,$req->post('startDate'),$req->post('endDate'));
			Yii::$app->end();			
		}
		return "No tienes permisos";
	}
	public function actionExportEmployees()
	{
		$req = Yii::$app->request;
		$companies = $req->post('companies',[]);
		$departments = $req->post('departments',[]);
		$jobs = $req->post('jobs',[]);
		$status = $req->post('status',[]);
		$validCompanies = array_values(ArrayHelper::map(Yii::$app->user->identity->companies,'id','id'));
		$validCompanies = array_intersect($validCompanies, $companies);
		Employees::get($validCompanies,$departments,$jobs,$status);
		Yii::$app->end();			
	}
	public function actionConcepts()
	{
		$req = Yii::$app->request;
		$idCompany = $req->post('company',-1);
		$departments = $req->post('departments',[]);
		$jobs = $req->post('jobs',[]);
		$status = $req->post('status',[]);
		if(Yii::$app->user->identity->hasCompany($idCompany)){
			Concepts::get($idCompany,$departments,$jobs,$status);
			Yii::$app->end();			
		}
	}
	public function actionExpiredContracts()
	{
		return $this->render('expired-contracts');
	}
	public function actionEmployees()
	{
		return $this->render('employees');
	}
}