<?php
namespace app\controllers;

use \Yii;
use app\components\Controller;
use app\models\VacationRequest;
use app\models\PermissionRequest;
use app\components\RequestsComponent;
use app\components\HolidaysComponent;
use app\components\EmployeesComponent;
use app\models\SettlementRequest;
use app\models\NoticeRequest;
use app\models\Incident;
use yii\helpers\Url;
use app\models\Employee;

class RequestsController extends Controller
{
	public function actionVacations()
	{
		$model = new VacationRequest;
		return $this->render('vacations.php',['model'=>$model]);
	}
	public function actionNotices()
	{
		$model = new NoticeRequest;
		return $this->render('notices.php',['model'=>$model]);
	}
	public function actionPermissions()
	{
		$model = new PermissionRequest;
		return $this->render('permissions.php',['model'=>$model]);
	}
	public function actionSettlement()
	{
		$model = new SettlementRequest;
		return $this->render('settlement.php',['model'=>$model]);
	}
	public function actionVacationsCreate()
	{
		$r = ['success'=>false];
		$model = new VacationRequest;
		$model->load($this->req->post());
		list($realBreakDays,$breaks,$holidays) = EmployeesComponent::getEmployeeBreaksByDays($model->employee,$model->startDate,$model->daysToUse);
		$auxDays = ($realBreakDays+count($breaks)+count($holidays))-1;
		$model->endDate = date('Y-m-d',strtotime($model->startDate." +$auxDays day"));
		$model->workDate = date('Y-m-d',strtotime($model->endDate." +1 day"));
		$model->requiredBreakDaysNumber = count($breaks)+count($holidays);
		if(!$this->requestsInRange($model->idEmployee,$model->startDate,$model->endDate)){
			if($model->save()){
				RequestsComponent::setVacations($model);
				$r['success'] = true;
			}else{
				$aux = $model->getErrors();
				$r['message'] = reset($aux)[0];
			}
		}else{
			$r['message'] = "Existen papeletas en el rango seleccionado, revisar incidencias";
		}
		return json_encode($r);
	}
	public function requestsInRange($idEmployee,$startDate,$endDate)
	{
		return Incident::find()
		->where(['idEmployee'=>$idEmployee])
		->andWhere("date >= '$startDate' AND date <= '$endDate' AND idRequest > 0")
		->count()>0;
	}
	public function actionPermissionsCreate()
	{
		$r = ['success'=>false];
		$req = Yii::$app->request;
		$model = new PermissionRequest;
		$model->load($req->post());

		list($realBreakDays,$breaks,$holidays) = EmployeesComponent::getEmployeeBreaksByDays($model->employee,$model->startDate,$model->daysToUse);
		$auxDays = ($realBreakDays+count($breaks)+count($holidays))-1;
		$model->endDate = date('Y-m-d',strtotime($model->startDate." +$auxDays day"));
		$model->workDate = date('Y-m-d',strtotime($model->endDate." +1 day"));
		$model->requiredBreakDaysNumber = count($breaks)+count($holidays);
		if(!$this->requestsInRange($model->idEmployee,$model->startDate,$model->endDate)){
			if($model->save()){
				RequestsComponent::setPermission($model);
				$r['success'] = true;
			}else{
				$aux = $model->getErrors();
				$r['message'] = reset($aux)[0];
			}
		}else{
			$r['message'] = "Existen papeletas en el rango seleccionado, revisar incidencias";
		}
		return json_encode($r);
	}
	public function actionSettlementCreate()
	{
		$r = ['success'=>false];
		$model = new SettlementRequest;
		$model->load(Yii::$app->request->post());
			if($model->save()){
				RequestsComponent::sendSettlementNotification($model);
				$r['success'] = true;
			}else{
				$aux = $model->getErrors();
				$r['message'] = reset($aux)[0];
			}
		return json_encode($r);
	}
	public function actionNoticesCreate()
	{
		$r = ['success'=>false];
		$model = new NoticeRequest;
		$model->load(Yii::$app->request->post());
		// tipo de aviso
		if(!$this->requestsInRange($model->idEmployee,$model->eventDate,$model->eventDate)){
			if($model->save()){
				RequestsComponent::setNotice($model);
				$r['success'] = true;
			}else{
				$aux = $model->getErrors();
				$r['message'] = reset($aux)[0];
			}
		}else{
			$r['message'] = "Existe una papeleta en la fecha del evento, revisar incidencias";			
		}
		return json_encode($r);
	}
	public function actionCompanyEmployees()
	{
		$req = Yii::$app->request;
		$idCompany = $req->post('id');
		$html = "<option value=''>Seleccionar</option>";
		if(Yii::$app->user->identity->hasCompany($idCompany)){
			foreach (Employee::findByCompany($idCompany)->all() as $emp) {
				$html.="<option value='{$emp->id}'>{$emp->fullNameInverse}</option>";
			}
		}
		return $html;
	}
	public function actionEmployeeData()
	{
		$idEmployee = Yii::$app->request->post('id');
		$emp = Employee::findOneByCompany($idEmployee);
		$data =[];
		if($emp){
			$data = [
				'departmentName'=>$emp->department->name,
				'jobName'=>$emp->job->name,
				'entryYear'=>$emp->getDateField('entryDateCompany','Y'),
			];
		}
		return json_encode($data);
	}
	public function actionVacationsDelete($id)
	{
		if (Yii::$app->user->identity->isAdmin()) {
			$re = VacationRequest::findOne($id);
			if($re) $re->delete();
			return json_encode(['success'=>true,'callbackScript'=>"reloadAjaxTables();"]);
		}
	}
	public function actionSettlementDelete($id)
	{
		if (Yii::$app->user->identity->isAdmin()) {
			$re = SettlementRequest::findOne($id);
			if($re) $re->delete();
			return json_encode(['success'=>true,'callbackScript'=>"reloadAjaxTables();"]);
		}
	}
	public function actionNoticesDelete($id)
	{
		if (Yii::$app->user->identity->isAdmin()) {
			$re = NoticeRequest::findOne($id);
			if($re) $re->delete();
			return json_encode(['success'=>true,'callbackScript'=>"reloadAjaxTables();"]);
		}
	}
	public function actionPermissionsDelete($id)
	{
		if (Yii::$app->user->identity->isAdmin()) {
			$re = PermissionRequest::findOne($id);
			if($re) $re->delete();
			return json_encode(['success'=>true,'callbackScript'=>"reloadAjaxTables();"]);
		}
	}
	public function actionPrint($id,$type)
	{
		$models = [
			'vacation'=> "app\models\VacationRequest",
			'settlement'=> "app\models\SettlementRequest",
			'permission'=> "app\models\PermissionRequest",
			'notice'=> "app\models\NoticeRequest",
		];
		$r = $models[$type]::findOne($id);
		$pdf = RequestsComponent::getRequestPdf($r,$type);
        $pdf->Output("solicitud.pdf",'I');
	}
	public function actionVacationsListing()
	{
		$models = VacationRequest::findByCompany();
		$cols = ['Employees.lastName1','periodStartYear','startDate','endDate','breakDays','workDate','creationDate','creationDate'];
		$cols2 = ['Employees.firstName','Employees.lastName1','Employees.idCompany'];
		$totalAll = $models->count();
		// var_dump($_GET['columns']);
		// criteria
		foreach ($cols2 as $index => $c) {
			$models->andWhere(['like',$c,$_GET['columns'][$index]['search']['value']]);
		}
		$totalFiltered = $models->count();
		$models->orderBy($cols[$_GET['order'][0]['column']].' '.$_GET['order'][0]['dir']);
		$models->limit($_GET['length'])->offset($_GET['start']);
		$r=[];
		$r['draw'] = $_GET['draw'];
		$r['recordsTotal']=$totalAll;
		$r['recordsFiltered']=$totalFiltered;
		$r['data']=[];
		foreach($models->all() as $m) {
			$actions=[];
			$actions[]="<a href='".Url::to(['requests/print','id'=>$m->id,'type'=>'vacation'])."' class='btn btn-xs btn-primary' target='_blank'><i class='fa fa-print'></i></a>";
			if(Yii::$app->user->identity->isAdmin()) $actions[]="<a href='".Url::to(['requests/vacations-delete','id'=>$m->id])."' class='btn btn-xs btn-danger show-warning ajaxLink'><i class='fa fa-trash'></i></a>";
			$r['data'][]=[
				$m->employee->fullNameInverse,
				$m->periodStartYear.' - '.$m->periodEndYear,
				$m->getDateField('startDate','d/m/Y'),
				$m->getDateField('endDate','d/m/Y'),
				$m->daysToUseWithBreaks,
				$m->getDateField('workDate','d/m/Y'),
				$m->getDateField('creationDate','d/m/Y H:i:s'),
				"<div class='text-center'>".implode('',$actions)."</div>",
			];
		}
		$r['error']='';
		return json_encode($r);
	}
	public function actionNoticesListing()
	{
		$models = NoticeRequest::findByCompany();
		$cols = ['Employees.lastName1','noticeType','eventDate','workDays','extraHours','doubleWorkDay','creationDate','creationDate'];
		$cols2 = ['Employees.firstName','Employees.lastName1','Employees.idCompany'];
		$totalAll = $models->count();
		// criteria
		foreach ($cols2 as $index => $c) {
			$models->andWhere(['like',$c,$_GET['columns'][$index]['search']['value']]);
		}
		$totalFiltered = $models->count();
		$models->orderBy($cols[$_GET['order'][0]['column']].' '.$_GET['order'][0]['dir']);
		$models->limit($_GET['length'])->offset($_GET['start']);
		$r=[];
		$r['draw'] = $_GET['draw'];
		$r['recordsTotal']=$totalAll;
		$r['recordsFiltered']=$totalFiltered;
		$r['data']=[];
		foreach($models->all() as $m) {
			$actions=[];
			$actions[]="<a href='".Url::to(['requests/print','id'=>$m->id,'type'=>'notice'])."' class='btn btn-xs btn-primary' target='_blank'><i class='fa fa-print'></i></a>";
			if(Yii::$app->user->identity->isAdmin()) $actions[]="<a href='".Url::to(['requests/notices-delete','id'=>$m->id])."' class='btn btn-xs btn-danger show-warning ajaxLink'><i class='fa fa-trash'></i></a>";
			$r['data'][]=[
				$m->employee->fullNameInverse,
				NoticeRequest::$typeOptions[$m->noticeType],
				$m->getDateField('eventDate','d/m/Y'),
				$m->workDays,
				$m->extraHours,
				$m->doubleWorkDay,
				$m->getDateField('creationDate','d/m/Y H:i:s'),
				"<div class='text-center'>".implode('',$actions)."</div>",
			];
		}
		$r['error']='';
		return json_encode($r);
	}
	public function actionPermissionsListing()
	{
		$models = PermissionRequest::findByCompany();
		$cols = ['Employees.lastName1','startDate','endDate','daysToUse','workDate','creationDate','creationDate'];
		$cols2 = ['Employees.firstName','Employees.lastName1','Employees.idCompany'];
		$totalAll = $models->count();
		// criteria
		foreach ($cols2 as $index => $c) {
			$models->andWhere(['like',$c,$_GET['columns'][$index]['search']['value']]);
		}
		$totalFiltered = $models->count();
		$models->orderBy($cols[$_GET['order'][0]['column']].' '.$_GET['order'][0]['dir']);
		$models->limit($_GET['length'])->offset($_GET['start']);
		$r=[];
		$r['draw'] = $_GET['draw'];
		$r['recordsTotal']=$totalAll;
		$r['recordsFiltered']=$totalFiltered;
		$r['data']=[];
		foreach($models->all() as $m) {
			$actions=[];
			$actions[]="<a href='".Url::to(['requests/print','id'=>$m->id,'type'=>'permission'])."' class='btn btn-xs btn-primary' target='_blank'><i class='fa fa-print'></i></a>";
			if(Yii::$app->user->identity->isAdmin()) $actions[]="<a href='".Url::to(['requests/permissions-delete','id'=>$m->id])."' class='btn btn-xs btn-danger show-warning ajaxLink'><i class='fa fa-trash'></i></a>";
			$r['data'][]=[
				$m->employee->fullNameInverse,
				$m->getDateField('startDate','d/m/Y'),
				$m->getDateField('endDate','d/m/Y'),
				$m->daysToUseWithBreaks,
				$m->getDateField('workDate','d/m/Y'),
				$m->getDateField('creationDate','d/m/Y H:i:s'),
				"<div class='text-center'>".implode('',$actions)."</div>",
			];
		}
		$r['error']='';
		return json_encode($r);
	}
	public function actionSettlementListing()
	{
		$models = SettlementRequest::findByCompany();
		$cols = ['Employees.lastName1','fechaBaja','fechaDePago','lugarDePago','bajaImss','creationDate','creationDate'];
		$cols2 = ['Employees.firstName','Employees.lastName1','Employees.idCompany'];
		$totalAll = $models->count();
		// criteria
		foreach ($cols2 as $index => $c) {
			$models->andWhere(['like',$c,$_GET['columns'][$index]['search']['value']]);
		}
		$totalFiltered = $models->count();
		$models->orderBy($cols[$_GET['order'][0]['column']].' '.$_GET['order'][0]['dir']);
		$models->limit($_GET['length'])->offset($_GET['start']);
		$r=[];
		$r['draw'] = $_GET['draw'];
		$r['recordsTotal']=$totalAll;
		$r['recordsFiltered']=$totalFiltered;
		$r['data']=[];
		foreach($models->all() as $m) {
			$actions=[];
			$actions[]="<a href='".Url::to(['requests/print','id'=>$m->id,'type'=>'settlement'])."' class='btn btn-xs btn-primary' target='_blank'><i class='fa fa-print'></i></a>";
			if(Yii::$app->user->identity->isAdmin()) $actions[]="<a href='".Url::to(['requests/settlement-delete','id'=>$m->id])."' class='btn btn-xs btn-danger show-warning ajaxLink'><i class='fa fa-trash'></i></a>";
			$r['data'][]=[
				$m->employee->fullNameInverse,
				$m->getDateField('fechaBaja','d/m/Y'),
				$m->getDateField('fechaDePago','d/m/Y h:i:s'),
				$m->lugarDePago,
				$m->bajaImss?"SI":"NO",
				$m->getDateField('creationDate','d/m/Y H:i:s'),
				"<div class='text-center'>".implode('',$actions)."</div>",
			];
		}
		$r['error']='';
		return json_encode($r);
	}
	public function actionEmployeeBreaks()
	{
		$emp = Employee::findOneByCompany($this->req->post('id'));
		$startDate = $this->req->post('startDate');
		$days = $this->req->post('days');
		list($realBreakDays,$breaks,$holidays,$permissions,$vacations) = EmployeesComponent::getEmployeeBreaksByDays($emp,$startDate,$days);
		return json_encode(count($breaks)+count($holidays)+count($permissions)+count($vacations));
	}
	public function actionUpdateRequests()
	{
		$reqsV = VacationRequest::find()->all();
		$reqsP = PermissionRequest::find()->all();
		$reqsN = NoticeRequest::find()->all();
		foreach ($reqsV as $req) {
			$req->requiredBreakDaysNumber = count($req->requiredBreakDays);
			RequestsComponent::setVacations($req);
			$req->save();
		}
		foreach ($reqsP as $req) {
			$req->requiredBreakDaysNumber = count($req->requiredBreakDays);
			RequestsComponent::setPermission($req);
			$req->save();
		}
		foreach ($reqsN as $req) {
			RequestsComponent::setNotice($req);
			// $req->save();
		}
	}
}