<?php
namespace app\controllers;

use \Yii;
use app\components\Controller;
use yii\helpers\Url;
use app\models\User;
use app\models\Company;
use app\models\Department;
use app\models\PermitDepartment;

class UsersController extends Controller
{
	public $newTitle = "Nuevo usuario";
	public function actionCreate()
	{
		$r = ['success'=>false];
		$n = new User;
		$n->scenario='create';
		$n->attributes = $_POST['User'];
		$n->generateAuthKey();
		if($n->save()){
			$r['success']=true;
			$r['message']="Guardado Exitoso";
        	$editLink = Url::to(['users/edit','id'=>$n->id]);
			 $req['callbackScript']="
            	closeCurrentModal(function(){
            		generateModal(null,'$editLink',1000);
            	});
            ";
		}else{
			$aux = $n->getErrors();
			$r['message']=reset($aux)[0];
		}
		return json_encode($r);
	}
	public function actionPermissions($id)
	{
		$user = User::findOne($id);
		return $this->renderModal('permissions','Permisos de '.$user->fullName,['user'=>$user]);
	}
	public function actionEdit($id)
	{
		$model = User::findOne($id);
		return $this->renderModal('edit',$model->fullName,['model'=>$model]);	
	}
	public function actionUpdatepass($id)
	{
		$user = User::findOne($id);
		$user->scenario = 'changePassword';
		$user->password_hash = $_POST['User']['password_hash'];
		$user->comparePassword = $_POST['User']['comparePassword'];
		$r = ['success'=>false];
		if($user->save()){
			$r['success']=true;
			$r['message']="Contraseña actualizada";
			$r['callbackScript']="closeCurrentModal();";
		}else{
			$aux = $user->getErrors();
			$r['message']=reset($aux)[0];
		}
		return json_encode($r);
	}
	public function actionUpdate($id)
	{
		$r = ['success'=>false];
		$n = User::findOne($id);
		$n->attributes = $_POST['User'];
		if($n->save()){
			$r['success']=true;
			$r['message']="Actualizacion Exitosa";
			$r['callbackScript']="
			reloadCurrentModal();
			";
		}else{
			$aux = $n->getErrors();
			$r['message']=reset($aux)[0];
		}
		return json_encode($r);
	}
	public function actionDelete($id)
	{
		$s = User::findOne($id);
		$s->updateAttributes(['status'=>User::Status_Deleted]);
		return json_encode(['success'=>true,'callbackScript'=>"reloadAjaxTables();"]);
	}
	public function actionListing()
    {
    	$users = User::find()->where(['status'=>User::Status_Active]);
		$cols = ['username','firstName','lastName','email','status','role','id'];
		$totalAll = $users->count();
		// criteria
		foreach ($cols as $index => $c) {
			$users->andWhere(['like',$c,$_GET['columns'][$index]['search']['value']]);
		}
		$totalFiltered = $users->count();
		$users->orderBy($cols[$_GET['order'][0]['column']].' '.$_GET['order'][0]['dir']);
		$users->limit($_GET['length'])->offset($_GET['start']);
		$r=[];
		$r['draw'] = $_GET['draw'];
		$r['recordsTotal']=$totalAll;
		$r['recordsFiltered']=$totalFiltered;
		$r['data']=[];
		foreach($users->all() as $u) {
			$actions=$this->generateHtmlActions($u,'850');
			$r['data'][]=[
				$u->username,
				$u->firstName,
				$u->lastName,
				$u->email,
				User::$roleOptions[$u->role],
				$u->getStatusArray()[$u->status],
				"<div class='text-center'>".implode('',$actions)."</div>",
			];
		}
		$r['error']='';
		return json_encode($r);
    }
    public function actionUpdatePermissions($id)
    {
    	$r = ['success'=>true];
    	$user = User::findOne($id);
    	$companyAccess = Yii::$app->request->post('companies');
    	$departmentAccess = Yii::$app->request->post('departments');
    	// eliminamos permisos a empresas
    	foreach ($user->companies as $c) {
    		if(!in_array($c->id,$companyAccess)) $user->unlink('companies',$c,true);
    	}
    	// agregamos nuevos permisos a empresas
    	foreach ($companyAccess as $cId) {
    		$com = Company::findOne($cId);
    		if($com){
    			if(!$user->hasCompany($cId)) $user->link('companies',$com);
    		}
    	}
    	// permisos a departamentos
    	foreach (Company::find()->all() as $c) {
    		$cId = $c->id;
    		$departmentsIds = isset($departmentAccess[$cId])?$departmentAccess[$cId]:[];
    		// eliminamos permisos
	    	foreach ($user->getPermitDepartments()->where(['idCompany'=>$cId])->all() as $pd) {
	    		if(!in_array($pd->idDepartment,$departmentsIds)) $pd->delete();
	    	}
	    	// agregamos nuevos permisos
	    	foreach ($departmentsIds as $dId) {
	    		$dep = Department::findOne($dId);
	    		if($dep && !$user->hasDepartment($dId,$cId)){
    				$aux = new PermitDepartment;
    				$aux->idUser = $user->id;
    				$aux->idDepartment = $dId;
    				$aux->idCompany = $cId;
    				$aux->save();
	    		}
	    	}    		
    	}
    	$user->save();
    	return json_encode($r);
    }
}