<?php 
namespace app\models;
use Yii;
use yii\db\ActiveRecord;
use app\models\Period;

class Company extends ActiveRecord{
	public static function tableName()
	{
		return 'Companies';
	}
	public function rules()
	{
		return [
			[['name','idWorkingPeriod','payDays'],'required','message'=>'Campo <strong>{attribute}</strong> obligatorio'],
			['name','unique','message'=>"El nombre <strong>{value}</strong> ya ha sido usado"],
			// ['payDaysJson','checkPayDays'],
			[['address'],'safe'],
		];
	}
	public function checkPayDays($attribute,$params)
	{
		$days = json_decode($this->payDaysJson);
		if($days!==null && $days){
			if(count($days)==2 && $days[0]==$days[1])
				$this->addError('payDays','Debes seleccionar <strong>2 días</strong> de pago diferentes en el mes');
		}else{
			$this->addError('payDays',"Hay un error en los días de pago");
		}
	}
	public function getWorkingPeriod()
	{
		return $this->hasOne(WorkingPeriod::classname(),['id'=>'idWorkingPeriod']);
	}
	public function getPeriods()
	{
		return $this->hasMany(Period::classname(),['idCompany'=>'id']);
	}
	public function getEmployees()
	{
		return $this->hasMany(Employee::classname(),['idCompany'=>'id']);
	}
	public function getDepartments()
	{
        return $this->hasMany(Department::classname(),['id'=>'idDepartment'])->viaTable('CompaniesDepartments',['idCompany'=>'id']);
	}
    public function hasDepartment($id)
    {
        return $this->getDepartments()->andWhere(['id'=>$id])->count()>0;
    }
    public function getLastClosedPeriod()
    {
    	return $this->getPeriods()
		->andWhere(['status'=>Period::STATUS_CLOSE])
		->orderBy('endDate DESC')
		->one();
    }
}
 ?>