<?php 
namespace app\models;
use Yii;
use app\models\BaseModel;
use app\models\Employee;

class EmployeeChange extends BaseModel{
    const CHANGE_TYPE_STATUS_ACTIVE = Employee::STATUS_ACTIVE;
    const CHANGE_TYPE_STATUS_INACTIVE = Employee::STATUS_INACTIVE;
    const CHANGE_TYPE_STATUS_READMISSION = Employee::STATUS_READMISSION;
    const CHANGE_TYPE_SALARY = 4;

    public static $changeTypeOptions = [
        self::CHANGE_TYPE_STATUS_ACTIVE =>'ALTA',
        self::CHANGE_TYPE_STATUS_INACTIVE =>'BAJA',
        self::CHANGE_TYPE_STATUS_READMISSION =>'REINGRESO',
        self::CHANGE_TYPE_SALARY =>'MODIFICACION',
    ];
	public static function tableName()
	{
		return "EmployeesChanges";
	}
	public function rules()
	{
		return [
			// [],
		];
	}
	public function getFiscalSalary()
    {
        return $this->salaries*$this->minimumSalary;
    }
    public function getFiscalMonthlySalary()
    {
        return $this->fiscalSalary*365/12;
    }
    public function getEmployee()
    {
        return $this->hasOne(Employee::classname(),['id'=>'idEmployee']);
    }
    public function getCreationUser()
    {
        return $this->hasOne(User::classname(),['id'=>'idCreationUser']);
    }
    public function getFileName()
    {
        $fileName = [];
        if($this->changeType==self::CHANGE_TYPE_SALARY) $fileName[] = "MOD.SALARIO";
        else $fileName[] = self::$changeTypeOptions[$this->changeType];
        $fileName[]=$this->employee->refId;
        $fileName[]=$this->employee->fullNameInverse;
        return str_replace(' ', '_', implode('_', $fileName));
    }
}