<?php 
namespace app\models;

use Yii;
use yii\helpers\ArrayHelper;
use app\models\BaseModel;
use app\models\Incident;
use app\models\IncidentCategory;

class NoticeRequest extends BaseModel{
    const TYPE_DT = 1;
    const TYPE_FL = 2; 
    const TYPE_TD = 3;
    const TYPE_HE = 4;

    public static $typeOptions = [
    	self::TYPE_DT=>'Descanso trabajado',
    	self::TYPE_FL=>'Día festivo trabajado',
    	self::TYPE_TD=>'Turno doble',
    	self::TYPE_HE=>'Horas extra',
    ];
	public static function tableName(){
		return "NoticeRequests";
	}
	public function rules(){
		return [
			[[	
				'idEmployee',
				'workDays',
				'extraHours',
				'doubleWorkDay',
				'eventDate',
				'noticeType',
			],'required','message'=>'El campo <strong>{attribute}</strong> es obligatorio'],
			[[
				'workDays',
				'extraHours',
				'doubleWorkDay',
			],'number','message'=>'El campo <strong>{attribute}</strong> debe ser un numero'],
			[[
				'notes'
			],'safe']
		];	
	}
	public function attributeLabels()
	{
		return [
			'workDays'=>'Días a laborar',
			'extraHours'=>'Horas extra',
			'doubleWorkDay'=>'Doble turno',
			'idEmployee'=>'Empleado',
			'noticeType'=>'Tipo de aviso',
		];
	}
	public function getEmployee()
	{
		return $this->hasOne(Employee::classname(),['id'=>'idEmployee']);
	}
	public function getDepartment()
	{
		return $this->hasOne(Department::classname(),['id'=>'idDepartment']);
	}
	public function getJob()
	{
		return $this->hasOne(Job::classname(),['id'=>'idJob']);
	}
	public function beforeSave($insert)
    {
    	if (parent::beforeSave($insert)) {
            if(empty($this->idCreationUser)) $this->idCreationUser = Yii::$app->user->identity->id;
            $this->idJob = $this->employee->idJob;
            $this->idDepartment = $this->employee->idDepartment;
    		return true;
    	} else {
    		return false;
    	}
    }
    public static function findbyCompany($companyId=false)
    {
        $companyId = $companyId===false?ArrayHelper::map(Yii::$app->user->identity->companies,'id','id'):$companyId; 
        return parent::find()->joinWith('employee')->where(['Employees.idCompany'=>$companyId]);
    }
	public function afterDelete()
	{
	    parent::afterDelete();
	    $incs = Incident::find()
		->where(['idRequest'=>$this->id,'requestType'=>Incident::REQUEST_TYPE_NOTICE])
		->all();
		foreach ($incs as $inc) {
			// $inc->idRequest = -1;
			$inc->delete();
		}
	}
	public function getIdIncidentCategory()
	{
		if($this->noticeType==self::TYPE_DT){
			return IncidentCategory::findOne(['tag'=>'DT'])->id;
		}else if($this->noticeType==self::TYPE_FL){
			return IncidentCategory::findOne(['tag'=>'FL'])->id;
		}else if($this->noticeType==self::TYPE_TD){
			return IncidentCategory::findOne(['tag'=>'TD'])->id;
		}
	}
}

?>