<?php 
namespace app\models;

use Yii;
use yii\helpers\ArrayHelper;
use app\models\BaseModel;
use app\models\Incident;

class SettlementRequest extends BaseModel{
	public $horaDePago;
	public $minutoDePago;
	public static function tableName(){
		return "SettlementRequests";
	}
	public function rules(){
		return [
			[[	
				'idEmployee',
				'fechaDePago',
				'fechaBaja',
				'lugarDePago',
				'bajaImss',
				'diasGratificacion',
				'vacacionesGozadas',
				'primaVacacionesPagadas',
			],'required','message'=>'El campo <strong>{attribute}</strong> es obligatorio'],
			[[
				'diasGratificacion',
				'vacacionesGozadas',
				'primaVacacionesPagadas',
				'diasDevengados',
				'horasExtra',
				'diaFestivo',
				'primaDominical',
				'compensacion',
				'bono',
				'otrasPercepciones',
				'ausentismos',
				'sueldoPagadoDeMas',
				'cxc',
				'prestamo',
				'otrosDescuentos',
			],'number','message'=>'El campo <strong>{attribute}</strong> debe ser un numero'],
			[[
				'diasDevengados',
				'horasExtra',
				'diaFestivo',
				'primaDominical',
				'compensacion',
				'bono',
				'otrasPercepciones',
				'ausentismos',
				'sueldoPagadoDeMas',
				'cxc',
				'prestamo',
				'otrosDescuentos',
				'observaciones',
				'horaDePago',
				'minutoDePago',
			],'safe']
		];	
	}
	public function attributeLabels()
	{
		return [
			'idEmployee'=>'Empleado',
		];
	}
	public function getEmployee()
	{
		return $this->hasOne(Employee::classname(),['id'=>'idEmployee']);
	}
	public function beforeSave($insert)
    {
    	if (parent::beforeSave($insert)) {
            if(empty($this->idCreationUser)) $this->idCreationUser = Yii::$app->user->identity->id;
            $this->fechaDePago = $this->getDateField('fechaDePago','Y-m-d')."  {$this->horaDePago}:{$this->minutoDePago}:00";
    		return true;
    	} else {
    		return false;
    	}
    }
    public static function findbyCompany($companyId=false)
    {
        $companyId = $companyId===false?ArrayHelper::map(Yii::$app->user->identity->companies,'id','id'):$companyId; 
        return parent::find()->joinWith('employee')->where(['Employees.idCompany'=>$companyId]);
    }
	public function afterDelete()
	{
	    parent::afterDelete();
	}
}

?>