<?php 
namespace app\models;

use Yii;
use yii\helpers\ArrayHelper;
use app\models\BaseModel;
use app\models\Incident;
use app\components\IncidentCategoriesComponent;

class VacationRequest extends BaseModel{
	public static function tableName(){
		return "VacationRequests";
	}
	public function rules(){

		return [
			[[	
				'idEmployee',
				'periodStartYear',
				'periodEndYear',
				'totalDays',
				'usedDays',
				'availableDays',
				'daysToUse',
				'startDate',
			],'required','message'=>'El campo <strong>{attribute}</strong> es obligatorio'],
			[[
				'periodStartYear',
				'periodEndYear',
				'totalDays',
				'usedDays',
				'availableDays',
				'daysToUse',
			],'number','message'=>'El campo <strong>{attribute}</strong> debe ser un numero'],
			[['notes'],'safe']
		];	
	}
	public function attributeLabels()
	{
		return [
			'idEmployee'=>'Empleado',
			'idJob'=>'Puesto',
			'idDepartment'=>'Departamento',
			'periodStartYear'=>'Inicio de periodo',
			'periodEndYear'=>'Fin de periodo',
			'totalDays'=>'Días que corresponden',
			'usedDays'=>'Dias disfrutados',
			'availableDays'=>'Días disponibles',
			'daysToUse'=>'Dias a disfrutar',
			'startDate'=>'Fecha de inicio',
		];
	}
	public function getEmployee()
	{
		return $this->hasOne(Employee::classname(),['id'=>'idEmployee']);
	}
	public function getDepartment()
	{
		return $this->hasOne(Department::classname(),['id'=>'idDepartment']);
	}
	public function getJob()
	{
		return $this->hasOne(Job::classname(),['id'=>'idJob']);
	}
	public function beforeSave($insert)
    {
    	if (parent::beforeSave($insert)) {
            if(empty($this->idCreationUser)) $this->idCreationUser = Yii::$app->user->identity->id;
			$this->idJob = $this->employee->idJob;
			$this->idDepartment = $this->employee->idDepartment;
    		return true;
    	} else {
    		return false;
    	}
    }
    public static function findbyCompany($companyId=false)
    {
        $companyId = $companyId===false?ArrayHelper::map(Yii::$app->user->identity->companies,'id','id'):$companyId; 
        return parent::find()->joinWith('employee')->where(['Employees.idCompany'=>$companyId]);
    }
    public function getRequiredBreakDays()
    {
    	$aux = json_decode($this->jsonRequiredBreakDays);
    	return $aux?$aux:[];
    }
	public function afterDelete()
	{
	    parent::afterDelete();
    	$incs = Incident::find()
		->where(['idRequest'=>$this->id,'requestType'=>Incident::REQUEST_TYPE_VACATION])
		->all();
		$idAs = IncidentCategoriesComponent::get('-');
		$idVac = IncidentCategoriesComponent::get('V');
		foreach ($incs as $inc) {
			$inc->idRequest = -1;
			if($inc->idIncidentCategory==$idVac) $inc->idIncidentCategory = $idAs;
			$inc->save();
		}
	}
	public function getDaysToUseWithBreaks()
	{
		return $this->daysToUse+count($this->requiredBreakDays);
	}
}

?>