<?php 
use yii\helpers\Url;
use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use app\models\WorkingPeriod;
?>
<form method='post' data-reloadtables='true' enctype='multipart/form-data' class='ajaxSubmit validateForm' action='<?= Url::toRoute(['companies/update','id'=>$model->id]) ?>'>
    <div class="form-group">
        <label>Nombre</label>
        <?= Html::activeInput('text',$model,'name',['class'=>'form-control input-sm required']); ?>
    </div>
    <?php $auxId = Yii::$app->security->generateRandomString(5) ?>
    <div class="form-group">
        <label>Periodo de trabajo</label>
        <?= Html::activeDropDownList($model,'idWorkingPeriod',ArrayHelper::map(WorkingPeriod::find()->all(),'id','name'),['class'=>'form-control input-sm required']); ?>
    </div>
    <div class="form-group">
        <label>Días de pago (para contrato)</label>
        <?= Html::activeInput('text',$model,'payDays',['class'=>'form-control input-sm required']); ?>
    </div>
    <div class="form-group">
        <label>Domicilio</label>
        <?= Html::activeTextArea($model,'address',['class'=>'form-control input-sm required']); ?>
    </div>  
    <div class="form-group">
        <button type='submit' class='btn btn-primary'>Actualizar</button>
    </div>
</form>