<?php 
use yii\helpers\Url;
use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use app\models\ContractType;
use app\models\Department;
?>
<form method='post' enctype='multipart/form-data' class='ajaxSubmit validateForm' action='<?= Url::to(['contracts/update','id'=>$model->id]) ?>'>
    <div class="form-group">
        <label>Empresa</label>
        <input class='form-control input-sm' value='<?= $model->employee->company->name ?>' disabled>
    </div>
    <div class="form-group">
        <label>Empleado</label>
        <input type='text' value='<?= $model->employee->firstName.' '.$model->employee->lastName1.' '.$model->employee->lastName2 ?>' class='form-control input-sm' disabled>
        <?= Html::activeInput('hidden',$model,'idEmployee'); ?>
    </div>
    <div class="form-group">
        <label>Tipo de contrato</label>
        <?= Html::activeDropDownList($model,'idContractType',ArrayHelper::map(ContractType::find()->all(),'id','name'),['class'=>'form-control input-sm required']); ?>
    </div>
   <div class="form-group">
        <label>Departamento</label>
        <input type='text' class='form-control input-sm' value='<?= $model->department->name ?>' disabled>
    </div>
    <div class="form-group">
        <label>Puesto</label>
        <input type='text' class='form-control input-sm' value='<?= $model->job->name ?>' disabled>
    </div>      
    <div class="row">
        <div class="form-group col-md-6">
            <label>Fecha de inicio</label>
            <?= Html::activeInput('text',$model,'startDate',['class'=>'form-control input-sm required calendarField']); ?>
        </div>
        <div class="form-group col-md-6">
            <label>Fecha fin</label>
            <?= Html::activeInput('text',$model,'endDate',['class'=>'form-control input-sm required calendarField']); ?>
        </div>    
    </div>
    <div class="row">
        <div class="form-group col-md-4">
            <label>Ingreso Empresa</label>
            <?= Html::activeInput('text',$model,'entryDateCompany',['class'=>'form-control input-sm required calendarField']); ?>
        </div>    
        <div class="form-group col-md-4">
            <label>Ingreso IMSS</label>
            <?= Html::activeInput('text',$model,'entryDateImss',['class'=>'form-control input-sm required calendarField']); ?>
        </div>    
        <div class="form-group col-md-4">
            <label>Ingreso SAAV</label>
            <?= Html::activeInput('text',$model,'entryDateSaav',['class'=>'form-control input-sm required calendarField']); ?>
        </div>    
    </div>
    <div class="row">
        <div class="col-md-4 form-group">
            <label>Días de prueba</label>
            <?= Html::activeInput('text',$model,'testDays',['class'=>'form-control input-sm numberField']); ?>
        </div>
    </div>
    <div class="row">
        <?php $auxId = Yii::$app->security->generateRandomString(5) ?>
        <div class="col-md-2 form-group">
            <label>Salarios</label>
            <?= Html::activeInput('text',$model,'salaries',['class'=>'form-control input-sm required numberField2']); ?>
        </div>      
        <div class="col-md-5 form-group">
            <label>Salario mínimo </label>
           <div class="input-group input-group-sm">
                <span class='input-group-addon'>$</span>
                <input type='text' class='form-control input-sm numberField2 minimumSalary' value='<?= $model->minimumSalary ?>'  readonly>
                <div class="input-group-btn">
                    <a title='Actualiza salario minimo' href='<?= Url::to(['contracts/update-salary','id'=>$model->id]) ?>' class='show-warning ajaxLink btn btn-xs btn-warning' data-warning-message="Se cambiara el salario mínimo aplicado a este contrato, por el actual del sistema"><i class='fa fa-refresh'></i></a>
                </div>
            </div>
        </div>      
    </div>
    <div class="row">
        <div class="col-md-6 form-group">
            <label>Salario diario</label>
            <div class="input-group input-group-sm">
                <span class='input-group-addon'>$</span>
                <input readonly type='text' class='form-control numberField2 fiscalSalary' value='<?= $model->fiscalSalary ?>'>
            </div>
        </div>      
        <div class="col-md-6 form-group">
            <label>Salario mensual</label>
            <div class="input-group input-group-sm">
                <span class='input-group-addon'>$</span>
                <input readonly type='text' class='form-control numberField2 fiscalMonthlySalary' value='<?= $model->fiscalMonthlySalary ?>'>
            </div>
        </div>      
    </div>    
<!--     <div class="row">
        <div class="col-md-5 form-group">
            <label>Salario variable</label>
            <div class="input-group input-group-sm">
                <span class='input-group-addon'>$</span>
                <?= Html::activeInput('text',$model,'salary',['class'=>'form-control input-sm required number numberField2']); ?>
            </div>
        </div>      
    </div> -->
    <div class="form-group">
        <button type='submit' class='btn btn-primary'>Actualizar</button>
    </div>
</form>