<?php 
use yii\helpers\Url;
use yii\helpers\Html;
use app\models\Employee;
$model = new Employee;
?>
<div class="container">
		<div>
			<a href='/employees/new' data-container='#employeeBox' class="load-content btn-sm btn btn-default">
				<i class="fa fa-file-o"></i><br>
				Nuevo
			</a>
			<button type='button' class="submit-employee btn btn-default btn-sm">
				<i class="fa fa-check"></i><br>
				Guardar
			</button>
			<a href='/employees/search?actionButtonClass=employee-finded' data-toggle='modalDinamic' class="btn-sm btn btn-default">
				<i class="fa fa-search"></i><br>
				Buscar
			</a>
		</div>
		<hr>
		<div class="row">
			<div class="col-sm-3">
				<div class="well" style="min-height: 450px;overflow: auto">
					<?php foreach ($employees as $emp): ?>
						<a class='load-employee' data-employee-id="<?= $emp->id ?>" data-container='#employeeBox' href="<?= Url::to(['employees/edit','id'=>$emp->id]) ?>"><?= $emp->fullName ?><span class="loader pull-right" style="display: none;">	<i class="fa fa-refresh fa-spin"></i></span></a>
					<?php endforeach ?>				
				</div>
			</div>	
			<div class="col-sm-9" id='employeeBox' >
				<?= $this->render('info',['model'=>$model]) ?>
			</div>	
		</div>	
</div>