<?php 
use yii\helpers\Url;
use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use app\models\Department;
use app\models\Job;
use app\models\Employee;
 ?>
<form id='employeeForm' method='post' enctype='multipart/form-data' class='ajaxSubmit validateForm well' style="height: 450px;overflow: auto;" action='<?= $model->isNewRecord?'/employees/create':Url::to(['employees/update','id'=>$model->id]) ?>'>
    <div class="row">
        <div class="form-group col-sm-6">
            <label>Empresa</label>
            <?php $auxId = Yii::$app->security->generateRandomString(5) ?>
            <?= Html::activeDropDownList($model,'idCompany',ArrayHelper::map(Yii::$app->user->identity->companies,'id','name'),['class'=>'form-control input-sm','prompt'=>'Seleccionar']); ?>
        </div>
        <div class="form-group col-sm-6">
            <label>Estatus</label>
                <div class="input-group">
                    <input type="text" class="form-control input-sm" value="<?= $model->getStatusOptions()[$model->status] ?>" disabled>
                    <?php if (!$model->isNewRecord): ?>
                        <div class="input-group-btn">
                            <a href="<?= Url::to(['employees/edit-status','id'=>$model->id]) ?>" data-toggle='modalDinamic' class="btn <?= $model->status==Employee::STATUS_INACTIVE?'btn-success':'btn-danger' ?> btn-sm" ><i class="fa <?= $model->status==Employee::STATUS_INACTIVE?'fa-arrow-up':'fa-arrow-down' ?>"></i></a>
                        </div>
                    <?php endif ?>
                </div>                
        </div>
    </div>
    <div class="dinamic-tab">
        <ul class='nav nav-tabs'>
            <li class='active'> <a href="#" data-toggle='tab'>Generales</a></li>
            <li> <a href="#" data-toggle='tab'>Salario</a></li>
            <li> <a href="#" data-toggle='tab'>Datos de empleo</a></li>
            <li> <a href="#" data-toggle='tab'>Dirección y contacto</a></li>
            <li> <a href="#" data-toggle='tab'>Notas y documentos</a></li>
            <?php if (!$model->isNewRecord): ?>
            <li> <a href="#" data-toggle='tab'>Histórico</a></li>
            <?php endif ?>
        </ul>
        <div class="tab-content">
            <div class='tab-pane active'>
                <?= $this->render('tabs/generals',['model'=>$model]) ?>
            </div>
            <div class='tab-pane '>
                <?= $this->render('tabs/salary',['model'=>$model]) ?>
            </div>
            <div class='tab-pane '>
                <?= $this->render('tabs/job-data',['model'=>$model]) ?>
            </div>
            <div class='tab-pane '>
                <?= $this->render('tabs/address-contact',['model'=>$model]) ?>
            </div>
            <div class="tab-pane">
                <?= $this->render('tabs/documents',['model'=>$model]); ?>
            </div>
            <?php if (!$model->isNewRecord): ?>
            <div class="tab-pane">
                <?= $this->render('tabs/history',['model'=>$model]); ?>
            </div>                
            <?php endif ?>
        </div>
    </div>
</form>