<?php 
use yii\helpers\Url;
use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use app\models\IncidentCategory;
$parentSelected = $model->idIncidentCategoryParent>0;
?>
<div class="modal-header myheader">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
    <h3 class='modal-title'>Editar <?= $parentSelected?"sub-categoria":"categoría" ?> de incidencia</h3>
</div>
<form method='post' enctype='multipart/form-data' class='ajaxSubmit validateForm' action='<?= Url::to(['incident-categories/update','id'=>$model->id]) ?>'>
<div class="modal-body">
    <div class="form-group">
        <label>Categoría padre</label>
        <?php 
        $aux = ArrayHelper::map(IncidentCategory::find()->where('idIncidentCategoryParent <= 0')->all(),'id','name');
        $aux[0]="Ninguna";
        $auxAttrs = ['class'=>"form-control input-sm"];
        if($parentSelected) $auxAttrs['readonly']="readonly";
         ?>
        <?= Html::activeDropDownList($model,'idIncidentCategoryParent',$aux,$auxAttrs); ?>
    </div>
    <div class="form-group">
        <label>Nombre</label>
        <?= Html::activeInput('text',$model,'name',['class'=>'form-control input-sm required']); ?>
    </div>
    <?php if ($parentSelected): ?>
        <?= Html::activeInput('hidden',$model,'type') ?>
    <?php else: ?>
        <div class="form-group">
            <label>Tipo</label>
            <?= Html::activeDropDownList($model,'type',$model->getTypeOptions(),['class'=>'form-control input-sm']); ?>
        </div>
    <?php endif ?>
    <div class="form-group">
        <label>Descripción</label>
        <?= Html::activeTextarea($model,'description',['class'=>'form-control input-sm required','rows'=>3]); ?>
    </div>      
</div>
<div class="modal-footer text-right">
    <button type='button' data-dismiss='modal' class='btn btn-default'>Cancelar</button>
    <button type='submit' class='btn btn-primary'>Guardar</button>
</div>
</form>