<?php 
use yii\helpers\Url;
use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use app\models\IncidentCategory;
$model  =new IncidentCategory;
?>
<form method='post' enctype='multipart/form-data' class='ajaxSubmit validateForm' action='<?= Url::toRoute('incident-categories/create') ?>'>
    <div class="form-group">
        <label>Nombre</label>
        <?= Html::activeInput('text',$model,'name',['class'=>'form-control input-sm required']); ?>
    </div>
    <div class="form-group">
        <label>Etiqueta corta</label>
        <?= Html::activeInput('text',$model,'tag',['class'=>'form-control input-sm required']); ?>
    </div>
    <div class="form-group">
        <label>Tipo</label>
        <?= Html::activeDropDownList($model,'type',$model->getTypeOptions(),['class'=>'form-control input-sm']); ?>
    </div>
    <div class="form-group">
        <label>Descripción</label>
        <?= Html::activeTextarea($model,'description',['class'=>'form-control input-sm required','rows'=>3]); ?>
    </div>      
    <div class="form-group">
        <button type='submit' class='btn btn-primary'>Guardar</button>
    </div>
</form>