<?php
use app\components\IncidentsComponent;
use app\models\IncidentCategory;
use app\models\Period;

$incidentCategories = IncidentCategory::find()->all();

$auxWeek = ['D','L','M','M','J','V','S'];
$theadWeek = [];
$theadDays = [];
$auxStart = $period->getDateField('startDate');
$auxEnd = $period->getDateField('endDate');
$totalDays = 0;
while($auxStart<=$auxEnd){
	$theadWeek[]=$auxWeek[$auxStart->format('w')];
	$theadDays[]=$auxStart->format('M').'<br>'.$auxStart->format('d');
	$auxStart->modify('+1 day');
	$totalDays++;
}
?>
<style type="text/css">
* {font-size: 8pt}
table.incidents{text-align: center;font-size: 7pt}
table.incidents td{width: <?= 52/$totalDays ?>%}
table.incidents td.longs{width: 20%;text-align: left;}
table.incidents td.medium{width: 8%;text-align: left;}
</style>
<table style="width:100%">
<tr>
	<td>
		<p>Empresa: <strong><?= $period->company->name ?></strong></p>
		<p>Periodo: <strong><?= $period->getDateField('startDate')->format('d/m/Y') ?> - <?= $period->getDateField('endDate')->format('d/m/Y') ?></strong></p>
		<p>Estado: <strong><?= $period->getEnumField('status'); ?></strong></p>
		<?php if ($period->status!=Period::STATUS_OPEN): ?>
			<p>Enviado a revisión por: <strong><?= $period->userClosure->fullName ?></strong></p>
			<p>Fecha y Hora de envío: <strong><?= $period->getFullDateField('closureDate',true) ?></strong></p>
			<p>Cierre al: <strong><?= $period->getDateField('incidentsLastDate')->format('d/m/Y') ?></strong></p>	
		<?php endif ?>
		<?php if ($period->status==Period::STATUS_CLOSE && Yii::$app->user->identity->isAdmin()): ?>
			<p>Periodo aprobado y cerrado por: <strong><?= $period->userAproval->fullName ?></strong></p>	
		<?php endif ?>
	</td>
</tr>
</table>
<br>
<br>
<table class="incidents" border="1" cellpadding="5">
	<thead>
		<tr>
			<td rowspan="2" class="medium">ID</td>
			<td rowspan="2" class="longs">Empleado</td>
			<td rowspan="2" class="longs">Puesto</td>
			<td><?= implode("</td><td>",$theadWeek); ?></td>
		</tr>
		<tr>
			<td><?= implode("</td><td>",$theadDays); ?></td>
		</tr>
	</thead>
	<tbody>
		<?php foreach ($employees as $e): ?>
			<?php $prevIncidents = IncidentsComponent::getEmployeeIncidents($e->id,$period->startDate,$period->endDate); ?>
			<tr>
				<td class="medium"><?= $e->refId ?></td>
				<td class="longs"><?= $e->fullNameInverse ?></td>
				<td class="longs"><?= $e->job->name ?></td>
				<?php $auxStart = $period->getDateField('startDate'); ?>
				<?php while($auxStart<=$auxEnd): ?>
					<td>
						<?php $issetPrevDate = isset($prevIncidents[$auxStart->format('Y-m-d')]); ?>
						<?= $issetPrevDate?$prevIncidents[$auxStart->format('Y-m-d')]->incidentCategory->tag:'-' ?>
					</td>
				<?php $auxStart->modify('+1 day') ?>
				<?php endwhile; ?>
			</tr>
		<?php endforeach ?>
	</tbody>
</table>
<br>
<br>
<h3>Firmas de autorización</h3>
<table style="text-align:center">
	<tr>
		<td></td>
		<td>
			__________________________ <br><br>
			Visto Bueno	
		</td>
		<td>
			__________________________ <br><br>
			Autorizo	
		</td>
		<td></td>
	</tr>
</table>
<br>
<br>
<hr>
<h3>Nomenclatura</h3>
<table>
	<tr>
	<?php foreach ($incidentCategories as $ic): ?>
		<td>
			<strong><?= $ic->tag ?></strong> : <?= $ic->name ?>
		</td>
	<?php endforeach ?>	
	</tr>
</table>
<div >
</div>