<?php 
use yii\helpers\Url;
$auxId = Yii::$app->security->generateRandomString(5);
$i = 0;
?>
<div class="container no-back">
	<ul class="menu">
		<li>
			<a href="#" class="dropdown">Incidencias</a>
			<ul class="collapse">
				<li><a href="/incidents">Plantilla incidencias</a></li>
				<li><a href="/site/construction">Reportes</a></li>
			</ul>
		</li>
	<?php if (Yii::$app->user->identity->isAdmin()): ?>
		<li>
			<a  href="#" class="dropdown">Herramientas</a>
			<ul class="collapse">
				<li>
					<a  href="#" class="dropdown" href="/incidents">Exportación de incidencias</a>
					<form class="collapse" action='/reports/exportimp' method='get'>
						<div class="form-group">
							<label>Empresa</label>
							<select 
							id='company' 
							data-info='<?= Url::to(['incidents/company-options']) ?>' 
							name='company' 
							class='width-auto form-control input-sm load-info'
							required
							>
								<option value=''>Seleccionar</option>
								<?php foreach (Yii::$app->user->identity->companies as $c): ?>
									<option value='<?= $c->id ?>'><?= $c->name ?></option>
								<?php endforeach ?>
							</select>
						</div>
						<div class="form-group">
							<label>Periodo</label>
							<select name='period' class='width-auto form-control input-sm' required></select>
						</div>
						<div class="form-group">
							<button type="submit" class="btn btn-primary">Exportar</button>
						</div>
					</form>
				</li>
			</ul>
		</li>
	<?php endif; ?>
	</ul>
	
</div>