<?php
use yii\helpers\Url;
use app\components\PayrollConceptsComponent;
use app\models\Period;
use app\models\IncidentCategory;

$incidentCategories = IncidentCategory::find()->all();
?>
<h3><?= $period->company->name ?></h3>
<p>Periodo: <strong><?= $period->getDateField('startDate')->format('d/m/Y') ?> - <?= $period->getDateField('endDate')->format('d/m/Y') ?></strong></p>
<p>Estado: <strong><?= $period->getEnumField('status'); ?></strong></p>
<?php if ($period->status!=Period::STATUS_OPEN): ?>
	<p>Enviado a revisión por: <strong><?= $period->userClosure->fullName ?></strong></p>
	<p>Fecha y Hora de envío: <strong><?= $period->getFullDateField('closureDate',true) ?></strong></p>
	<p>Cierre al: <strong><?= $period->getDateField('incidentsLastDate')->format('d/m/Y') ?></strong></p>	
<?php endif ?>
<?php if ($period->status==Period::STATUS_CLOSE && Yii::$app->user->identity->isAdmin()): ?>
	<p>Periodo aprobado y cerrado por: <strong><?= $period->userAproval->fullName ?></strong></p>	
<?php endif ?>

<hr>
<form class='ajaxSubmit' method='post' action='<?= Url::to(['payroll-concepts/save-period','id'=>$period->id]) ?>'>
<div class="table-responsive">
<table id='payroll-concepts' class='incidentsTable table table-hover table-bordered text-center table-condensed'>
	<thead>
		<tr class='info'>
			<td></td>
			<td></td>
			<td></td>
			<td colspan="<?= count(PayrollConceptsComponent::$perceptions) ?>">Percepciones</td>
			<td colspan="<?= count(PayrollConceptsComponent::$deductions) ?>">Deducciones</td>
		</tr>
		<tr class='info'>
			<td class="text-left">ID</td>
			<td class="text-left">Empleado</td>
			<td class="text-left">Puesto</td>
			<?php foreach (PayrollConceptsComponent::$concepts as $p): ?>
				<td><?= $p ?></td>
			<?php endforeach ?>
		</tr>
	</thead>
	<?php $isAdmin = Yii::$app->user->identity->isAdmin() ?>
	<?php $disabled = ($period->status!=Period::STATUS_OPEN && !$isAdmin) || ($period->status==Period::STATUS_CLOSE); ?>
	<tbody>
		<?php foreach ($employees as $e): ?>
			<?php $employeeConcepts = PayrollConceptsComponent::getEmployeeConcepts($e->id,$period->id); ?>
			<tr>
				<td class='text-left'><?= $e->refId ?></td>
				<td class='text-left'><?= $e->fullNameInverse ?></td>
				<td class='text-left'><?= $e->job->name ?></td>
				<?php foreach (PayrollConceptsComponent::$concepts as $key => $p): ?>
					<td>
						<?php  $disabled2 = $key=='horasExtraP'?true:$disabled; ?>
						<input <?= $disabled || $disabled2?"disabled='disabled'":'' ?> type='text' class='' name='data[<?= $e->id ?>][<?= $key ?>]' value='<?= $employeeConcepts?$employeeConcepts->$key:0 ?>'>
					</td>
				<?php endforeach ?>
			</tr>
		<?php endforeach ?>
	</tbody>
</table>
</div>
<div class="text-right">
	<button type='submit' class='btn btn-primary <?= $disabled?'disabled':'' ?>' <?= $disabled?'disabled':'' ?>>Guardar Cambios</button>
</div>
</form>