<?php 
use yii\helpers\Url;
use yii\helpers\Html;
 ?>
<form class='validateForm ajaxSubmit' method='post' action='<?= Url::to(['periods/generate','id'=>$model->id]) ?>'>
	<div class="row">
		<div class="form-group col-xs-4">
			<label>Inicio</label>
			<input type='text' value='<?= date('Y-m-d') ?>' name='startDate' class='form-control input-sm calendarField'>
		</div>
		<div class="form-group col-xs-4">
			<label>Fin</label>
			<input type='text' value='<?= date('Y-m-d',strtotime('+1 year')) ?>' name='endDate' class='form-control input-sm calendarField'>
		</div>
		<div class="form-group col-xs-4">
			<label>Tipo de periodo</label>
			<input type='text' class='form-control input-sm' value='<?= $model->workingPeriod->name ?>' disabled>
		</div>
	</div>
	<br>
	<div class="form-group text-center">
		<a id='calcDates' href='<?= Url::to(['periods/calc-dates']) ?>' data-wp='<?= $model->idWorkingPeriod ?>' class='btn btn-primary' data-container='#periodsPreview' >Generar</a>
		<button type='submit' class='btn btn-primary'>Guardar</button>
	</div>
	<hr>
	<table class='table'>
		<thead>
			<tr>
				<th># Periodo</th>
				<th>Inicia</th>
				<th>Termina</th>
			</tr>
		</thead>
		<tbody id='periodsPreview'></tbody>
	</table>
</form>