<?php 
use yii\helpers\Url;
use app\models\Department;
use app\models\Job;
use app\models\Employee;
 ?>
 <div class="container no-back">
 	
<div class="row">
	<div class="col-xs-8">
		<form class='well' action='<?= Url::to(['reports/export-employees']) ?>' method='post'>
		<h3>Empleados</h3>
		<div class="row">
			<div class="col-xs-6 form-group">
				<label>Empresas:</label><br>
				<select 
				name='companies[]'
				class='selectField form-control input-sm'
				required
				data-number-displayed='1'
				data-max-height="300"
				multiple
				>
					<?php foreach (Yii::$app->user->identity->companies as $c): ?>
						<option selected="selected" value='<?= $c->id ?>'><?= $c->name ?></option>
					<?php endforeach ?>
				</select>
			</div>
			<div class="col-xs-6 form-group">
				<label>Departamentos:</label><br>
				<select 
				name='departments[]'
				class='selectField form-control input-sm'
				required
				data-number-displayed='1'
				data-max-height="300"
				multiple
				>
					<?php foreach (Department::find()->orderBy('name ASC')->all() as $d): ?>
						<option selected="selected" value='<?= $d->id ?>'><?= $d->name ?></option>
					<?php endforeach ?>
				</select>
			</div>
			<div class="col-xs-6 form-group">
				<label>Puestos:</label><br>
				<select 
				name='jobs[]'
				class='selectField form-control input-sm'
				data-number-displayed='1'
				data-max-height="300"
				required
				multiple
				>
					<?php foreach (Job::find()->orderBy('name ASC')->all() as $j): ?>
						<option selected="selected" value='<?= $j->id ?>'><?= $j->name ?></option>
					<?php endforeach ?>
				</select>
			</div>
			<div class="col-xs-6 form-group">
				<label>Estatus:</label><br>
				<select 
				name='status[]'
				class='selectField form-control input-sm'
				data-number-displayed='1'
				data-max-height="300"
				required
				multiple
				>
					<?php foreach (Employee::getStatusOptions() as $key=>$value): ?>
						<option selected="selected" value='<?= $key ?>'><?= $value ?></option>
					<?php endforeach ?>
				</select>
			</div>
		</div>
			<div class="form-group">
				<button type='submit' class='btn btn-submit btn-primary'>Exportar</button>
			</div>
		</form>
	</div>
</div>
<!-- <form class='well' action='<?= Url::to(['reports/concepts']) ?>' method='post'>
<h3>Conceptos</h3>
<div class="row">
	<div class="col-xs-4">
		<div class="form-group">
			<label>Fechas</label>
			<div class="row">
				<div class="col-xs-6">
					<input type="text" name="startDate" class="form-control input-sm calendarField" required>
				</div>
				<div class="col-xs-6">
					<input type="text" name="endDate" class="form-control input-sm calendarField" required>
				</div>
			</div>
		</div>
	</div>
	<div class="col-xs-8">
		<div class="row">
			<div class="col-xs-6 form-group">
				<label>Empresa:</label><br>
				<select 
				name='company'
				class='selectField form-control input-sm'
				required
				data-number-displayed='1'
				data-max-height="300"
				>
					<?php foreach (Yii::$app->user->identity->companies as $c): ?>
						<option value='<?= $c->id ?>'><?= $c->name ?></option>
					<?php endforeach ?>
				</select>
			</div>
			<div class="col-xs-6 form-group">
				<label>Departamentos:</label><br>
				<select 
				name='departments[]'
				class='selectField form-control input-sm'
				required
				data-number-displayed='1'
				data-max-height="300"
				multiple
				>
					<?php foreach (Department::find()->orderBy('name ASC')->all() as $d): ?>
						<option selected="selected" value='<?= $d->id ?>'><?= $d->name ?></option>
					<?php endforeach ?>
				</select>
			</div>
			<div class="col-xs-6 form-group">
				<label>Puestos:</label><br>
				<select 
				name='jobs[]'
				class='selectField form-control input-sm'
				data-number-displayed='1'
				data-max-height="300"
				required
				multiple
				>
					<?php foreach (Job::find()->orderBy('name ASC')->all() as $j): ?>
						<option selected="selected" value='<?= $j->id ?>'><?= $j->name ?></option>
					<?php endforeach ?>
				</select>
			</div>
			<div class="col-xs-6 form-group">
				<label>Estatus:</label><br>
				<select 
				name='status[]'
				class='selectField form-control input-sm'
				data-number-displayed='1'
				data-max-height="300"
				required
				multiple
				>
					<?php foreach (Employee::getStatusOptions() as $key=>$value): ?>
						<option selected="selected" value='<?= $key ?>'><?= $value ?></option>
					<?php endforeach ?>
				</select>
			</div>
		</div>
	</div>	
</div>
<div class="form-group">
	<button type='submit' class='btn btn-submit btn-primary'>Exportar</button>
</div>
</form> -->
 </div>