<?php 
	use yii\helpers\Html;
	use yii\helpers\Url;
	use app\models\IncidentCategory;
	$PCG = IncidentCategory::findOne(['tag'=>'PCG'])->id;
	$PSG = IncidentCategory::findOne(['tag'=>'PSG'])->id;
?>
<div class="container">
	
<h1>Papeleta de permisos</h1>
<form method='post' data-reset-on-success='true' class='ajaxSubmit validateForm' action='<?= Url::to(['requests/permissions-create']) ?>'>
<div class="row">
	<div class="col-xs-3 form-group">
		<label>Empresa</label>
		<select 
			class="load-content form-control input-sm"
			data-url='<?= Url::to(['requests/company-employees']) ?>'
			data-container="#employees"
		>
			<option value="">Seleccionar</option>
			<?php foreach (Yii::$app->user->identity->companies as $comp): ?>
					<option value="<?= $comp->id ?>"><?= $comp->name ?></option>
			<?php endforeach ?>
		</select>	
	</div>
	<div class="col-xs-3 form-group">
		<label>Tipo de permiso</label>
		<select class="form-control input-sm" name="PermissionRequest[idIncidentCategory]">
			<option value="<?= $PCG ?>">Con goce de sueldo</option>
			<option value="<?= $PSG ?>">Sin goce de sueldo</option>
		</select>
	</div>	
</div>
<h3 class="box-form-title">Datos del empleado</h3>
<div class="box-form">
	<div class="row">
		<div class="form-group col-xs-4">
			<label>Empleado:</label>
			<select
				id='employees'
				name='PermissionRequest[idEmployee]' 
				class="form-control input-sm requestEmployee"
				data-info-url="<?= Url::to(['requests/employee-data']) ?>"
				>
				<option value="">Seleccionar</option>
			</select>
		</div>
		<div class="form-group col-xs-3">
			<label>Puesto:</label>
			<input type="text" name="jobName" class="form-control input-sm" value='' disabled>
		</div>
		<div class="form-group col-xs-2">
			<label>Departamento:</label>
			<input type="text" name="departmentName" class="form-control input-sm" value='' disabled>
		</div>
		<div class="form-group col-xs-3">
			<label>Fecha de solicitud:</label>
			<input type="text" value="<?= date('d/m/Y') ?>" class="form-control input-sm" value='' disabled>
		</div>
	</div>
</div>
<h3 class="box-form-title">Solicitud de días de disfrute</h3>
<div class="box-form">
	<div class="row">
		<div class="form-group col-xs-2">
			<label>Días a disfrutar:</label>
			<div class="row">
				<div class="col-xs-6">
	        		<?= Html::activeInput('text',$model,'daysToUse',['class'=>'form-control input-sm number daysToUse required']); ?>
				</div>		
			</div>
		</div>
		<div class="form-group col-xs-2">
			<label>Fecha de inicio:</label>
			<input type="text" name="PermissionRequest[startDate]" class="form-control input-sm required calendarField startDate" >
		</div>
		<div class="form-group col-xs-2">
			<label>Descansos obligatorios:</label>
			<input type="text" name="breakDays" class="form-control input-sm breakDays"  disabled>
		</div>
		<div class="form-group col-xs-2">
			<label>Fecha termino:</label>
			<input type="text" name="endDate" class="form-control input-sm required calendarField endDate" disabled>
		</div>
		<div class="form-group col-xs-2">
			<label>Inicio a laborar:</label>
			<input type="text" name="workDate" class="form-control input-sm required calendarField workDate" disabled>
		</div>
	</div>
</div>
<h3 class="box-form-title">Observaciones</h3>
<div class="box-form">
	<div class="row">
		<div class="col-xs-6 form-group">
	    	<?= Html::activeTextarea($model,'notes',['class'=>'form-control input-sm']); ?>
		</div>	
		<div class="col-xs-6 form-group">
			<button type='submit' class="btn btn-block btn-primary">Guardar</button>
		</div>	
	</div>
</div>
</form>
<?php 
	$this->registerJsFile('@web/js/requests/vacations.js',['depends'=>[\app\assets\AppAsset::className()]]);
?>
</div>