<?php

/* @var $this yii\web\View */
/* @var $form yii\bootstrap\ActiveForm */
/* @var $model \common\models\LoginForm */

use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use app\assets\LoginAsset;
LoginAsset::register($this);

$this->title = 'Acceso SIGENI';
?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?= Html::csrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
</head>
<body class="soap-login-page">
    <?php $this->beginBody() ?>
    <header>
        <div class="logo">
            <img src="/images/logo2.png">
        </div>
    </header>
    <div class="container">
    <br>
    <br>
        <div id='login'>
            <img src="/images/login.jpg" style="max-width: 100%">
            <div>
                <h1 class="text-center">SIGENI</h1>
                <h4 class="text-center">Acceso para usuarios registrados de Grupo Lamhi</h4>
                <hr>
                <h4>Iniciar sesión</h4>
                <?php $form = ActiveForm::begin(['id' => 'LoginForm']); ?>
                    <div class="form-group">
                        <div class="input-group input-group">
                            <span class="input-group-addon"><i class="fa fa-user"></i></span>
                            <?= Html::activeInput('text',$model,'username',['id'=>'user','class'=>'form-control']) ?>
                        </div>
                        <?= Html::error($model,'username') ?>
                    </div>
                    <div class="form-group">
                        <div class="input-group">
                            <span class="input-group-addon"><i class="fa fa-key"></i></span>
                            <?= Html::activeInput('password',$model,'password',['id'=>'pass','class'=>'form-control']) ?>
                        </div>
                        <?= Html::error($model,'password') ?>
                    </div>
                    <div class="text-right">
                        <button type="submit" class="btn btn-primary">Iniciar</button>
                    </div>
                <?php ActiveForm::end(); ?>                
            </div>
        </div>
        <br>
        <br>
    </div>
    <footer>
        <p>Cancún Q. Roo Smza 32 Mza 01 Lote 01 Local 18 Plaza Hollywood C.P. 77500</p>
        <ul class="media_icon">
            <li><a href="#"><i class="fa fa-facebook"></i></a></li>
            <li><a href="#"><i class="fa fa-twitter"></i></a></li>
            <li><a href="#"><i class="fa fa-google-plus"></i></a></li>
            <li><a href="#"><i class="fa fa-linkedin"></i></a></li>
        </ul>
    </footer>
    <?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
