<?php 
use yii\helpers\Url;
use yii\helpers\Html;
use app\models\User;
?>
<form method='post' enctype='multipart/form-data' class='ajaxSubmit validateForm' action='<?= Url::to(['users/update','id'=>$model->id]) ?>'>
	<div class="row">
		<div class="form-group col-md-6">
			<label>Nombre de Usuario</label>
			<?= Html::activeInput('text',$model,'username',['class'=>'form-control input-sm required']); ?>
		</div>
		<div class="form-group col-md-6">
			<label>Rol de usuario</label>
			<?= Html::activeDropDownList($model,'role',User::$roleOptions,['class'=>'form-control input-sm required']); ?>
		</div>
	</div>
	<div class="row">
		<div class="form-group col-md-6">
			<label>Nombres</label>
			<?= Html::activeInput('text',$model,'firstName',['class'=>'form-control input-sm required']); ?>
		</div>
		<div class="form-group col-md-6">
			<label>Apellidos</label>
			<?= Html::activeInput('text',$model,'lastName',['class'=>'form-control input-sm required']); ?>
		</div>
	</div>
	<div class="row">
		<div class="form-group col-md-6">
			<label>Correo Electronico</label>
			<?= Html::activeInput('text',$model,'email',['class'=>'form-control input-sm required']); ?>
		</div>		
		<div class="form-group col-md-6">
			<label>Estatus</label>
			<?= Html::activeDropDownList($model,'status',$model->getStatusArray(),['class'=>'form-control input-sm required']); ?>
		</div>		
	</div>
	<div class="form-group text-right">
		<button type='button' class='btn btn-warning' data-toggle='modal' data-target='#user-change-pass'>Cambiar Contraseña</button>
	</div>
	<div class="form-group">
		<button type='submit' class='btn btn-primary'>Actualizar</button>
	</div>
</form>
<div class="modal fade" id='user-change-pass'>
	<div class="modal-header">
		<h3 class="modal-title">Cambio de Contraseña</h3>
	</div>
		<form method='post' class='ajaxSubmit validateForm' action='<?= Url::to(['users/updatepass','id'=>$model->id]) ?>'>
	<div class="modal-body">
		<?php $aux = new User; ?>
			<div class="form-group">
				<label>Contraseña</label>
				<?= Html::activeInput('password',$aux,'password_hash',['class'=>'form-control input-sm required']); ?>
			</div>
			<div class="form-group">
				<label>Repetir Contraseña</label>
				<?= Html::activeInput('password',$aux,'comparePassword',['class'=>'form-control input-sm required']); ?>
			</div>
	</div>
	<div class="modal-footer">
		<button type='button' class='btn btn-default' data-dismiss='modal'>Cancelar</button>
		<button type='submit' class='btn btn-primary'>Actualizar</button>
	</div>
		</form>
</div>