<?php 
use yii\helpers\Url;
use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use app\models\Company;
use app\models\Department;
?>
<form method='post' enctype='multipart/form-data' class='ajaxSubmit validateForm' action='<?= Url::toRoute(['users/update-permissions','id'=>$model->id]) ?>'>
    <?php $preCompanies = ArrayHelper::map($model->companies,'id','id') ?>
    <?php foreach (Company::find()->all() as $c): ?>
    <?php $preDepartments = ArrayHelper::map($model->getDepartments($c->id)->all(),'id','id'); ?>
        <label class='btn btn-link'>
            <input <?= in_array($c->id, $preCompanies)?"checked='checked'":'' ?> type='checkbox' name='companies[]' value='<?= $c->id ?>'>
            <strong><?= $c->name ?></strong>
        </label>
        <ul>
            <?php foreach ($c->departments as $d): ?>
            <li>
                <label class='btn-link'>
                    <input <?= in_array($d->id, $preDepartments)?"checked='checked'":'' ?> type='checkbox' name='departments[<?= $c->id ?>][]' value='<?= $d->id ?>'>
                    <?= $d->name ?>
                </label>
            </li>
            <?php endforeach ?>
        </ul>
    <?php endforeach ?>
    <div class="form-group text-right">
        <button type='submit' class='btn btn-primary'>Actualizar</button>
    </div>
</form>