$(document).ready(function(){
	$(document.body).on('change',"input[name='Employee[localEmployee]']",function(){
		var modal = $(this).closest('.modal');
		var selected = modal.find("input[name='Employee[localEmployee]']:checked");
		if(selected.length>0){
			if(selected.val()=='1'){
				modal.find('.localEmployeeDocs').show();
				modal.find('.foreignEmployeeDocs').hide();
			}else{
				modal.find('.localEmployeeDocs').hide();
				modal.find('.foreignEmployeeDocs').show();
			}			
		}
	});
	$("ul.menu a.dropdown").click(function(){
		$(this).next().collapse('toggle');
	});
	$(document.body).on('keyup',".salaries",function(e){
		var obj = $(this);
		var form = obj.closest('form');
		form.find(".fiscalSalary").val(form.find(".minimumSalary").val()*obj.val());
		form.find(".fiscalMonthlySalary").val(form.find(".minimumSalary").val()*obj.val()*365/12);
	});
	$(document.body).on('click','#contractPreview',function(e){
		e.preventDefault();
		var $this = $(this);
		var form = $this.closest('form');
		if(form.valid()){
			window.open($this.attr('href')+'?'+form.formSerialize())
			$("#warning-preview-contract").modal();
		}
	});
	// $("#incidentsCalendar input[name='period']").change(function(){
	// 	var period = $("#incidentsCalendar input[name='period']:checked").val();
	// 	$("#company").load($("#findCompanies").val(),{period:period});
	// });
	$(document.body).on('click',"#calcDates",function(e){
		e.preventDefault();
		var btn = $(this);
		var tbody = $(btn.data('container'));
		$.post(btn.attr('href'),{
			wp:btn.data('wp'),
			startDate:btn.closest('form').find("input[name='startDate']").val(),
			endDate:btn.closest('form').find("input[name='endDate']").val(),
		},function(dates){
			tbody.html(dates);
			applyToNewContainer(tbody);
		});
	});
	$(document.body).on('click','.add-children-fields',function(e){
		e.preventDefault();
		var form = $(this).closest('form');
		var container = form.find('.childrens');
		var newFields = container.children().eq(0).clone();
		newFields.find('label').hide();
		newFields.find('button').show();
		newFields.find('input').val('');
		newFields.find('select').val(0);
		container.append(newFields);
	});
	$(document.body).on('click','.childrens button',function(e){
		$(this).closest('.row').remove();
	});
	$("select[name='company'].load-info").change(function(e){
		var $this = $(this);
		var periodsSelect = $this.closest('form').find("select[name='period']");		
		var departmentSelect = $this.closest('form').find("select[name='department']");		
		$.post($this.data('info'),{company:$this.val()},function(r){
			if(periodsSelect.length>0){
				periodsSelect.html('');
				for(var p in r.periods){
					var selected = r.periods[p].selected?"selected='selected'":'';
					periodsSelect.append("<option "+selected+" value='"+r.periods[p].value+"'>"+r.periods[p].label+"</option>");
				}				
			}
			if(departmentSelect.length>0){
				departmentSelect.html('');
				for(var p in r.departments){
					departmentSelect.append("<option value='"+r.departments[p].value+"'>"+r.departments[p].label+"</option>");
				}				
			}
			$('.btn-consult').click();
		},'json');
	});
	
	$("select[name='calendar'],select[name='period'],select[name='department']").change(function(e){
		$('.btn-consult').click();
	});
	$("#incidentsCalendar").on('change','table tr td select',function(e){
		$("a[href='#confirmSendReview']").attr('disabled',true).addClass('disabled');
	});

	$(document.body).on('change',"select[name='Contract[idContractType]']",function(){
		var $this = $(this);
		var selected = $this.find('option:selected');
		if(selected.data('need-enddate')=='1'){
			$this.closest('form').find("input[name='Contract[endDate]']").attr('readonly',false);
		}else{
			$this.closest('form').find("input[name='Contract[endDate]']").attr('readonly',true);
		}
		if(selected.data('testdays')=='1'){
			$this.closest('form').find("input[name='Contract[testDays]']").attr('readonly',false);
		}else{
			$this.closest('form').find("input[name='Contract[testDays]']").attr('readonly',true);
		}
	});
	$(".btn-export").click(function(e){
		e.preventDefault();
		var $this = $(this);
		var form = $this.closest('form');
		var period  = form.find("[name='period']").val();
		var department  = form.find("[name='department']").val();
		var calendar = form.find("select[name='calendar']").val();
		if(period && department){
			window.open(calendar+'/export?'+form.formSerialize())
		}else{
			showAlert('Selecciona una empresa','error');
		}
	});
	$(".btn-export-imp").click(function(e){
		e.preventDefault();
		var $this = $(this);
		var form = $this.closest('form');
		var period  = form.find("[name='period']").val();
		var department  = form.find("[name='department']").val();
		var calendar = form.find("select[name='calendar']").val();
		if(period && department){
			window.open('reports/exportimp?'+form.formSerialize())
		}else{
			showAlert('Selecciona una empresa','error');
		}
	});
	$(".btn-consult").click(function(e){
		e.preventDefault();
		var btn = $(this);
		var form = btn.closest('form');
		var company  = form.find("[name='company']").val();
		var period  = form.find("[name='period']").val();
		var department  = form.find("[name='department']").val();
		var calendar = form.find("select[name='calendar']").val();
		btn.button('loading');
		if(company && period && department){
			$("#incidentsCalendar").html("<div class='text-center'><i class='fa fa-refresh fa-spin fa-3x'></i></div>");
			$("#incidentsCalendar").load(calendar+'/calendar?'+form.formSerialize(),function(){
				btn.button('reset');
				applyToNewContainer($(this));
			});
		}else{
			btn.button('reset');
			showAlert('Selecciona una empresa, periodo y departamentos','error');
		}
	});
	$("#incidentsCalendarForm").submit(function(e){
		e.preventDefault();
	});
	$(".requestEmployee").change(function(){
		var obj = $(this);
		$.post(obj.data('info-url'),{id:obj.val()},function(r){
			$("[name='jobName']").val(r.jobName);
			$("[name='departmentName']").val(r.departmentName);
			$("[name='entryYear']").val(r.entryYear);
		},'json');
	});
	$('.load-employee').click(function(e){
		e.preventDefault();
		var obj = $(this);
		var loader = obj.find('.loader');		
		loader.show();
		var container =$(obj.data('container')); 
		container.load(obj.attr('href')?obj.attr('href'):obj.data('url'),function(r){
			loader.hide();
			applyToNewContainer(container);
		});
	});

	$('.submit-employee').click(function(e){
		$("#employeeForm").submit();
	});
	$(document.body).on('click','.employee-finded',function(e){
		e.preventDefault();
		$(".load-employee[data-employee-id='"+$(this).attr('href')+"']").click();
		closeCurrentModal();
	});
	$(document.body).on('click','.new-contract',function(e){
		e.preventDefault();
		var empId = $(this).attr('href');
		closeCurrentModal(function(){
			generateModal($(this),'/contracts/new/'+empId);
		});
	});
});